/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.extras.annotations.validate;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.AnnotationsData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.ClassAnnotationData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.GenericAnnotationData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.MethodAnnotationData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.TypeAnnotationKey;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.validate.TypePathCheckerVisitor;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.TypeReference;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ParameterNode;
import org.objectweb.asm.tree.TypeAnnotationNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnnotationsDataValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationsDataValidator.class);

    @Nullable
    protected abstract ClassNode getClass(String var1, boolean var2);

    @VisibleForTesting
    protected void error(String message, Object ... args) {
        LOGGER.error(message, args);
    }

    public boolean checkData(AnnotationsData data) {
        boolean result = true;
        for (Map.Entry<String, ClassAnnotationData> classEntry : data.classes().entrySet()) {
            result &= this.checkClassData(classEntry.getKey(), classEntry.getValue());
        }
        return result;
    }

    private boolean checkClassData(String className, ClassAnnotationData classData) {
        ClassNode clazz = this.getClass(className, false);
        if (clazz == null) {
            this.error("No such target class: {}", className);
            return false;
        }
        boolean result = true;
        List<AnnotationNode> annotations = AnnotationsDataValidator.concatLists(clazz.visibleAnnotations, clazz.invisibleAnnotations);
        result &= this.checkAnnotationsToRemove(() -> className, classData.annotationsToRemove(), annotations);
        result &= this.checkAnnotationsToAdd(() -> className, classData.annotationsToAdd(), annotations);
        List<TypeAnnotationNode> typeAnnotations = AnnotationsDataValidator.concatLists(clazz.visibleTypeAnnotations, clazz.invisibleTypeAnnotations);
        result &= this.checkTypeAnnotationsToRemove(() -> className, classData.typeAnnotationsToRemove(), typeAnnotations);
        result &= this.checkTypeAnnotationsToAdd(() -> className, classData.typeAnnotationsToAdd(), typeAnnotations, typeAnnotation -> this.checkClassTypeAnnotation(typeAnnotation, clazz));
        for (Map.Entry<String, GenericAnnotationData> entry : classData.fields().entrySet()) {
            FieldNode field = AnnotationsDataValidator.findField(clazz, entry.getKey());
            if (field == null) {
                this.error("No such target field: {}.{}", className, entry.getKey());
                result = false;
                continue;
            }
            result &= this.checkGenericData(() -> className + "." + (String)fieldEntry.getKey(), entry.getValue(), AnnotationsDataValidator.concatLists(field.visibleAnnotations, field.invisibleAnnotations), AnnotationsDataValidator.concatLists(field.visibleTypeAnnotations, field.invisibleTypeAnnotations), typeAnnotation -> this.checkFieldTypeAnnotation(typeAnnotation, field));
        }
        for (Map.Entry<String, Record> entry : classData.methods().entrySet()) {
            MethodNode method = AnnotationsDataValidator.findMethod(clazz, entry.getKey());
            if (method == null) {
                this.error("No such target method: {}.{}", className, entry.getKey());
                result = false;
                continue;
            }
            result &= this.checkMethodData(() -> className + "." + (String)methodEntry.getKey(), (MethodAnnotationData)entry.getValue(), className, method);
        }
        return result;
    }

    private boolean checkGenericData(Supplier<String> errorKey, GenericAnnotationData data, List<AnnotationNode> annotations, List<TypeAnnotationNode> typeAnnotations, TypeAnnotationChecker typeAnnotationChecker) {
        boolean result = true;
        result &= this.checkAnnotationsToRemove(errorKey, data.annotationsToRemove(), annotations);
        result &= this.checkAnnotationsToAdd(errorKey, data.annotationsToAdd(), annotations);
        result &= this.checkTypeAnnotationsToRemove(errorKey, data.typeAnnotationsToRemove(), typeAnnotations);
        return result &= this.checkTypeAnnotationsToAdd(errorKey, data.typeAnnotationsToAdd(), typeAnnotations, typeAnnotationChecker);
    }

    private boolean checkMethodData(Supplier<String> errorKey, MethodAnnotationData data, String className, MethodNode method) {
        boolean result = true;
        List<AnnotationNode> annotations = AnnotationsDataValidator.concatLists(method.visibleAnnotations, method.invisibleAnnotations);
        result &= this.checkAnnotationsToRemove(errorKey, data.annotationsToRemove(), annotations);
        result &= this.checkAnnotationsToAdd(errorKey, data.annotationsToAdd(), annotations);
        List<TypeAnnotationNode> typeAnnotations = AnnotationsDataValidator.concatLists(method.visibleTypeAnnotations, method.invisibleTypeAnnotations);
        result &= this.checkTypeAnnotationsToRemove(errorKey, data.typeAnnotationsToRemove(), typeAnnotations);
        result &= this.checkTypeAnnotationsToAdd(errorKey, data.typeAnnotationsToAdd(), typeAnnotations, typeAnnotation -> this.checkMethodTypeAnnotation(typeAnnotation, className, method));
        int syntheticParamCount = 0;
        if (method.parameters != null) {
            for (ParameterNode parameterNode : method.parameters) {
                if ((parameterNode.access & 0x1000) == 0) continue;
                ++syntheticParamCount;
            }
        }
        for (Map.Entry entry : data.parameters().entrySet()) {
            int paramIndex = (Integer)entry.getKey();
            if (paramIndex < 0 || paramIndex >= Type.getArgumentCount((String)method.desc) - syntheticParamCount) {
                this.error("Invalid parameter index: {} for method: {}", paramIndex, errorKey.get());
                result = false;
                continue;
            }
            List<AnnotationNode> paramAnnotations = AnnotationsDataValidator.concatLists(method.visibleParameterAnnotations == null || paramIndex >= method.visibleParameterAnnotations.length ? null : method.visibleParameterAnnotations[paramIndex], method.invisibleParameterAnnotations == null || paramIndex >= method.invisibleParameterAnnotations.length ? null : method.invisibleParameterAnnotations[paramIndex]);
            result &= this.checkGenericData(() -> (String)errorKey.get() + ":" + paramIndex, (GenericAnnotationData)entry.getValue(), paramAnnotations, List.of(), typeAnnotation -> true);
            if (((GenericAnnotationData)entry.getValue()).typeAnnotationsToRemove().isEmpty() && ((GenericAnnotationData)entry.getValue()).typeAnnotationsToAdd().isEmpty()) continue;
            this.error("Type annotations cannot be added directly to method parameters: {}", errorKey.get());
            result = false;
        }
        return result;
    }

    private boolean checkAnnotationsToRemove(Supplier<String> errorKey, Set<String> annotationsToRemove, List<AnnotationNode> annotations) {
        LinkedHashSet<String> annotationsNotRemoved = new LinkedHashSet<String>(annotationsToRemove);
        for (AnnotationNode annotationNode : annotations) {
            annotationsNotRemoved.remove(Type.getType((String)annotationNode.desc).getInternalName());
        }
        if (annotationsNotRemoved.isEmpty()) {
            return true;
        }
        for (String string : annotationsNotRemoved) {
            this.error("Trying to remove annotation {} from {} but it's not present", string, errorKey.get());
        }
        return false;
    }

    private boolean checkAnnotationsToAdd(Supplier<String> errorKey, List<AnnotationNode> annotationsToAdd, List<AnnotationNode> annotations) {
        HashSet<String> existingAnnotations = new HashSet<String>();
        for (AnnotationNode annotation : annotations) {
            existingAnnotations.add(annotation.desc);
        }
        boolean result = true;
        for (AnnotationNode annotation : annotationsToAdd) {
            if (!existingAnnotations.add(annotation.desc)) {
                this.error("Trying to add annotation {} to {} but it's already present", annotation.desc, errorKey.get());
                result = false;
            }
            result &= this.checkAnnotation(errorKey, annotation);
        }
        return result;
    }

    private boolean checkTypeAnnotationsToRemove(Supplier<String> errorKey, Set<TypeAnnotationKey> typeAnnotationsToRemove, List<TypeAnnotationNode> typeAnnotations) {
        LinkedHashSet<TypeAnnotationKey> typeAnnotationsNotRemoved = new LinkedHashSet<TypeAnnotationKey>(typeAnnotationsToRemove);
        for (TypeAnnotationNode typeAnnotationNode : typeAnnotations) {
            typeAnnotationsNotRemoved.remove(new TypeAnnotationKey(typeAnnotationNode.typeRef, AnnotationsDataValidator.typePathToString(typeAnnotationNode.typePath), Type.getType((String)typeAnnotationNode.desc).getInternalName()));
        }
        if (typeAnnotationsNotRemoved.isEmpty()) {
            return true;
        }
        for (TypeAnnotationKey typeAnnotationKey : typeAnnotationsNotRemoved) {
            this.error("Trying to remove type annotation {} (typeRef={}, typePath={}) from {} but it's not present", typeAnnotationKey.name(), typeAnnotationKey.typeRef(), typeAnnotationKey.typePath(), errorKey.get());
        }
        return false;
    }

    private boolean checkTypeAnnotationsToAdd(Supplier<String> errorKey, List<TypeAnnotationNode> typeAnnotationsToAdd, List<TypeAnnotationNode> typeAnnotations, TypeAnnotationChecker checker) {
        HashSet<TypeAnnotationKey> existingTypeAnnotations = new HashSet<TypeAnnotationKey>();
        for (TypeAnnotationNode typeAnnotation : typeAnnotations) {
            existingTypeAnnotations.add(new TypeAnnotationKey(typeAnnotation.typeRef, AnnotationsDataValidator.typePathToString(typeAnnotation.typePath), typeAnnotation.desc));
        }
        boolean result = true;
        for (TypeAnnotationNode typeAnnotation : typeAnnotationsToAdd) {
            if (!existingTypeAnnotations.add(new TypeAnnotationKey(typeAnnotation.typeRef, AnnotationsDataValidator.typePathToString(typeAnnotation.typePath), typeAnnotation.desc))) {
                this.error("Trying to add annotation {} (typeRef={}, typePath={}) to {} but it's already present", typeAnnotation.desc, typeAnnotation.typeRef, typeAnnotation.typePath, errorKey.get());
                result = false;
            }
            result &= checker.checkTypeAnnotation(typeAnnotation);
        }
        return result;
    }

    private boolean checkClassTypeAnnotation(TypeAnnotationNode typeAnnotation, ClassNode clazz) {
        String typePathError;
        if (!this.checkTypeRef(typeAnnotation.typeRef)) {
            return false;
        }
        TypeReference typeRef = new TypeReference(typeAnnotation.typeRef);
        final TypePathCheckerVisitor typePathChecker = new TypePathCheckerVisitor(typeAnnotation.typePath);
        switch (typeRef.getSort()) {
            case 0: {
                return this.checkTypeParameterTypeAnnotation("class", typeAnnotation, clazz.signature, typeRef.getTypeParameterIndex());
            }
            case 17: {
                if (this.checkTypeParameterBoundTypeAnnotation("class", typeAnnotation, clazz.signature, typeRef.getTypeParameterIndex(), typeRef.getTypeParameterBoundIndex(), typePathChecker)) break;
                return false;
            }
            case 16: {
                final int superTypeIndex = typeRef.getSuperTypeIndex();
                if (superTypeIndex == -1) {
                    if (clazz.signature == null) {
                        typePathChecker.visitClassType(Objects.requireNonNullElse(clazz.superName, "java/lang/Object"));
                        typePathChecker.visitEnd();
                        break;
                    }
                    new SignatureReader(clazz.signature).accept(new SignatureVisitor(this, 589824){

                        public SignatureVisitor visitSuperclass() {
                            return typePathChecker;
                        }
                    });
                    break;
                }
                if (superTypeIndex >= clazz.interfaces.size()) {
                    this.error("Invalid type reference for class type annotation: {}, interface index {} out of bounds", typeAnnotation.typeRef, superTypeIndex);
                    return false;
                }
                if (clazz.signature == null) {
                    typePathChecker.visitClassType((String)clazz.interfaces.get(superTypeIndex));
                    typePathChecker.visitEnd();
                    break;
                }
                new SignatureReader(clazz.signature).accept(new SignatureVisitor(this, 589824){
                    int interfaceIndex;
                    {
                        super(arg0);
                        this.interfaceIndex = 0;
                    }

                    public SignatureVisitor visitInterface() {
                        if (this.interfaceIndex++ == superTypeIndex) {
                            return typePathChecker;
                        }
                        return this;
                    }
                });
                break;
            }
            default: {
                this.error("Invalid type reference for class type annotation: {}", typeAnnotation.typeRef);
                return false;
            }
        }
        if ((typePathError = typePathChecker.getError()) != null) {
            this.error("Invalid type path for class type annotation, typeRef: {}, error: {}", typeAnnotation.typeRef, typePathError);
            return false;
        }
        return true;
    }

    private boolean checkFieldTypeAnnotation(TypeAnnotationNode typeAnnotation, FieldNode field) {
        if (!this.checkTypeRef(typeAnnotation.typeRef)) {
            return false;
        }
        if (new TypeReference(typeAnnotation.typeRef).getSort() != 19) {
            this.error("Invalid type reference for field type annotation: {}", typeAnnotation.typeRef);
            return false;
        }
        String signature = Objects.requireNonNullElse(field.signature, field.desc);
        TypePathCheckerVisitor typePathChecker = new TypePathCheckerVisitor(typeAnnotation.typePath);
        new SignatureReader(signature).acceptType((SignatureVisitor)typePathChecker);
        String typePathError = typePathChecker.getError();
        if (typePathError != null) {
            this.error("Invalid type path for field type annotation, typeRef: {}, error: {}", typeAnnotation.typeRef, typePathError);
            return false;
        }
        return true;
    }

    private boolean checkMethodTypeAnnotation(TypeAnnotationNode typeAnnotation, String className, MethodNode method) {
        String typePathError;
        if (!this.checkTypeRef(typeAnnotation.typeRef)) {
            return false;
        }
        TypeReference typeRef = new TypeReference(typeAnnotation.typeRef);
        final TypePathCheckerVisitor typePathChecker = new TypePathCheckerVisitor(typeAnnotation.typePath);
        switch (typeRef.getSort()) {
            case 1: {
                return this.checkTypeParameterTypeAnnotation("method", typeAnnotation, method.signature, typeRef.getTypeParameterIndex());
            }
            case 18: {
                if (this.checkTypeParameterBoundTypeAnnotation("method", typeAnnotation, method.signature, typeRef.getTypeParameterIndex(), typeRef.getTypeParameterBoundIndex(), typePathChecker)) break;
                return false;
            }
            case 20: {
                if (method.signature == null) {
                    new SignatureReader(Type.getReturnType((String)method.desc).getDescriptor()).acceptType((SignatureVisitor)typePathChecker);
                    break;
                }
                new SignatureReader(method.signature).accept(new SignatureVisitor(this, 589824){

                    public SignatureVisitor visitReturnType() {
                        return typePathChecker;
                    }
                });
                break;
            }
            case 21: {
                if ((method.access & 8) != 0 || "<init>".equals(method.name)) {
                    this.error("Invalid type reference for method type annotation: {}, method receiver used in a static context", typeAnnotation.typeRef);
                    return false;
                }
                typePathChecker.visitClassType(className);
                typePathChecker.visitEnd();
                break;
            }
            case 22: {
                final int formalParamIndex = typeRef.getFormalParameterIndex();
                if (method.signature == null) {
                    int nonSyntheticParams = 0;
                    boolean foundArgument = false;
                    for (Type argumentType : Type.getArgumentTypes((String)method.desc)) {
                        if ((method.access & 0x1000) != 0 || nonSyntheticParams++ != formalParamIndex) continue;
                        foundArgument = true;
                        new SignatureReader(argumentType.getDescriptor()).acceptType((SignatureVisitor)typePathChecker);
                        break;
                    }
                    if (foundArgument) break;
                    this.error("Invalid type reference for method type annotation: {}, formal parameter index {} out of bounds", typeAnnotation.typeRef, formalParamIndex);
                    return false;
                }
                var visitor = new SignatureVisitor(this, 589824){
                    int paramIndex;
                    boolean found;
                    {
                        super(arg0);
                        this.paramIndex = 0;
                        this.found = false;
                    }

                    public SignatureVisitor visitParameterType() {
                        if (this.paramIndex++ == formalParamIndex) {
                            this.found = true;
                            return typePathChecker;
                        }
                        return this;
                    }
                };
                new SignatureReader(method.signature).accept(visitor);
                if (visitor.found) break;
                this.error("Invalid type reference for method type annotation: {}, formal parameter index {} out of bounds", typeAnnotation.typeRef, formalParamIndex);
                return false;
            }
            case 23: {
                final int throwsIndex = typeRef.getExceptionIndex();
                if (method.signature == null) {
                    if (method.exceptions == null || throwsIndex >= method.exceptions.size()) {
                        this.error("Invalid type reference for method type annotation: {}, exception index {} out of bounds", typeAnnotation.typeRef, throwsIndex);
                        return false;
                    }
                    typePathChecker.visitClassType((String)method.exceptions.get(throwsIndex));
                    typePathChecker.visitEnd();
                    break;
                }
                var visitor = new SignatureVisitor(this, 589824){
                    int exceptionIndex;
                    boolean found;
                    {
                        super(arg0);
                        this.exceptionIndex = 0;
                        this.found = false;
                    }

                    public SignatureVisitor visitExceptionType() {
                        if (this.exceptionIndex++ == throwsIndex) {
                            this.found = true;
                            return typePathChecker;
                        }
                        return this;
                    }
                };
                new SignatureReader(method.signature).accept(visitor);
                if (visitor.found) break;
                this.error("Invalid type reference for method type annotation: {}, exception index {} out of bounds", typeAnnotation.typeRef, throwsIndex);
                return false;
            }
            default: {
                this.error("Invalid type reference for method type annotation: {}", typeAnnotation.typeRef);
                return false;
            }
        }
        if ((typePathError = typePathChecker.getError()) != null) {
            this.error("Invalid type path for method type annotation, typeRef: {}, error: {}", typeAnnotation.typeRef, typePathError);
            return false;
        }
        return true;
    }

    private boolean checkTypeParameterTypeAnnotation(String memberType, TypeAnnotationNode typeAnnotation, @Nullable String signature, int typeParamIndex) {
        int formalParamCount;
        if (signature == null) {
            formalParamCount = 0;
        } else {
            var formalParamCounter = new SignatureVisitor(this, 589824){
                int count = 0;

                public void visitFormalTypeParameter(String name) {
                    ++this.count;
                }
            };
            new SignatureReader(signature).accept(formalParamCounter);
            formalParamCount = formalParamCounter.count;
        }
        boolean result = true;
        if (typeParamIndex >= formalParamCount) {
            this.error("Invalid type reference for {} type annotation: {}, formal parameter index {} out of bounds", memberType, typeAnnotation.typeRef, typeParamIndex);
            result = false;
        }
        if (typeAnnotation.typePath != null && typeAnnotation.typePath.getLength() != 0) {
            this.error("Non-empty type path for annotation doesn't make sense for {}_TYPE_PARAMETER", memberType.toUpperCase(Locale.ROOT));
            result = false;
        }
        return result;
    }

    private boolean checkTypeParameterBoundTypeAnnotation(String memberType, TypeAnnotationNode typeAnnotation, @Nullable String signature, final int typeParamIndex, final int typeParamBoundIndex, final TypePathCheckerVisitor typePathChecker) {
        var visitor = new SignatureVisitor(this, 589824){
            boolean found;
            int formalParamIndex;
            int boundIndex;
            {
                super(arg0);
                this.found = false;
                this.formalParamIndex = -1;
                this.boundIndex = 0;
            }

            public void visitFormalTypeParameter(String name) {
                ++this.formalParamIndex;
            }

            public SignatureVisitor visitClassBound() {
                if (this.formalParamIndex == typeParamIndex && this.boundIndex++ == typeParamBoundIndex) {
                    this.found = true;
                    return typePathChecker;
                }
                return this;
            }

            public SignatureVisitor visitInterfaceBound() {
                return this.visitClassBound();
            }
        };
        if (signature != null) {
            new SignatureReader(signature).accept(visitor);
        }
        if (!visitor.found) {
            this.error("Invalid type reference for {} type annotation: {}, formal parameter index {} bound index {} out of bounds", memberType, typeAnnotation.typeRef, typeParamIndex, typeParamBoundIndex);
            return false;
        }
        return true;
    }

    private boolean checkTypeRef(int typeRef) {
        int mask;
        switch (typeRef >>> 24) {
            case 0: 
            case 1: 
            case 22: {
                int n = -65536;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                int n = -16777216;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 66: {
                int n = -256;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                int n = -16776961;
                break;
            }
            default: {
                int n = mask = 0;
            }
        }
        if (mask == 0 || (typeRef & ~mask) != 0) {
            this.error("Invalid type reference {}", typeRef);
            return false;
        }
        return true;
    }

    private boolean checkAnnotation(Supplier<String> errorKey, AnnotationNode annotation) {
        if (!annotation.desc.startsWith("L") || !annotation.desc.endsWith(";")) {
            this.error("Invalid annotation descriptor: {}", annotation.desc);
            return false;
        }
        String internalName = annotation.desc.substring(1, annotation.desc.length() - 1);
        ClassNode annotationClass = this.getClass(internalName, true);
        if (annotationClass == null || (annotationClass.access & 0x2000) == 0) {
            this.error("No such annotation class: {}", internalName);
            return false;
        }
        LinkedHashSet<String> missingRequiredAttributes = new LinkedHashSet<String>();
        HashMap<String, Type> attributeTypes = new HashMap<String, Type>();
        for (MethodNode method : annotationClass.methods) {
            if ((method.access & 0x400) == 0) continue;
            attributeTypes.put(method.name, Type.getReturnType((String)method.desc));
            if (method.annotationDefault != null) continue;
            missingRequiredAttributes.add(method.name);
        }
        boolean result = true;
        if (annotation.values != null) {
            for (int i = 0; i < annotation.values.size(); i += 2) {
                String key = (String)annotation.values.get(i);
                Object value = annotation.values.get(i + 1);
                Type expectedType = (Type)attributeTypes.get(key);
                if (expectedType == null) {
                    this.error("Unknown annotation attribute: {}.{}", internalName, key);
                    result = false;
                    continue;
                }
                result &= this.checkAnnotationValue(errorKey, key, value, expectedType);
                missingRequiredAttributes.remove(key);
            }
        }
        if (!missingRequiredAttributes.isEmpty()) {
            result = false;
            this.error("Annotation applied to {} is missing required attributes: {}", errorKey.get(), missingRequiredAttributes);
        }
        return result;
    }

    private boolean checkAnnotationValue(Supplier<String> errorKey, String name, Object value, Type expectedType) {
        if (expectedType.getSort() == 9) {
            if (!(value instanceof List)) {
                this.error("Annotation value is of type {}, expected array for attribute {}", AnnotationsDataValidator.getTypeName(value), name);
                return false;
            }
            List values = (List)value;
            boolean result = true;
            for (Object element : values) {
                result &= this.checkAnnotationValue(errorKey, name, element, expectedType.getElementType());
            }
            return result;
        }
        boolean result = true;
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        boolean wrongType = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, Type.class, String[].class, AnnotationNode.class, List.class}, (Object)object2, n)) {
            case 0 -> {
                Boolean ignored = (Boolean)object2;
                if (expectedType.getSort() != 1) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                Byte ignored = (Byte)object2;
                if (expectedType.getSort() != 3) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                Character ignored = (Character)object2;
                if (expectedType.getSort() != 2) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                Short ignored = (Short)object2;
                if (expectedType.getSort() != 4) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                Integer ignored = (Integer)object2;
                if (expectedType.getSort() != 5) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                Long ignored = (Long)object2;
                if (expectedType.getSort() != 7) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                Float ignored = (Float)object2;
                if (expectedType.getSort() != 6) {
                    yield true;
                }
                yield false;
            }
            case 7 -> {
                Double ignored = (Double)object2;
                if (expectedType.getSort() != 8) {
                    yield true;
                }
                yield false;
            }
            case 8 -> {
                String ignored = (String)object2;
                if (!expectedType.getDescriptor().equals("Ljava/lang/String;")) {
                    yield true;
                }
                yield false;
            }
            case 9 -> {
                Type ignored = (Type)object2;
                if (!expectedType.getDescriptor().equals("Ljava/lang/Class;")) {
                    yield true;
                }
                yield false;
            }
            case 10 -> {
                String[] enumValue = (String[])object2;
                if (!enumValue[0].startsWith("L") || !enumValue[0].endsWith(";")) {
                    this.error("Invalid enum descriptor: {}", enumValue[0]);
                    result = false;
                    yield false;
                }
                boolean wrongEnumType = !expectedType.getDescriptor().equals(enumValue[0]);
                ClassNode enumClass = this.getClass(enumValue[0].substring(1, enumValue[0].length() - 1), true);
                if (enumClass == null) {
                    this.error("No such enum class: {}", enumValue[0]);
                    result = false;
                    yield wrongEnumType;
                }
                if (!AnnotationsDataValidator.enumValueExists(enumClass, enumValue[1])) {
                    this.error("Enum value {} does not exist in class {}", enumValue[1], enumValue[0]);
                    result = false;
                    yield wrongEnumType;
                }
                yield wrongEnumType;
            }
            case 11 -> {
                AnnotationNode annotation = (AnnotationNode)object2;
                result &= this.checkAnnotation(errorKey, annotation);
                if (!expectedType.getDescriptor().equals(annotation.desc)) {
                    yield true;
                }
                yield false;
            }
            case 12 -> {
                List ignored = (List)object2;
                yield true;
            }
            default -> throw new AssertionError((Object)("Unexpected annotation value type: " + value.getClass().getName()));
        };
        if (wrongType) {
            this.error("Annotation value is of type {}, expected {} for attribute {}", AnnotationsDataValidator.getTypeName(value), expectedType.getClassName(), name);
            result = false;
        }
        return result;
    }

    @Nullable
    private static FieldNode findField(ClassNode clazz, String nameAndDesc) {
        for (FieldNode field : clazz.fields) {
            if (!nameAndDesc.equals(field.name + ":" + field.desc)) continue;
            return field;
        }
        return null;
    }

    @Nullable
    private static MethodNode findMethod(ClassNode clazz, String nameAndDesc) {
        for (MethodNode method : clazz.methods) {
            if (!nameAndDesc.equals(method.name + method.desc)) continue;
            return method;
        }
        return null;
    }

    private static boolean enumValueExists(ClassNode enumClass, String name) {
        for (FieldNode field : enumClass.fields) {
            if (!field.name.equals(name) || (field.access & 0x4000) == 0) continue;
            return true;
        }
        return false;
    }

    private static String getTypeName(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, Type.class, String[].class, AnnotationNode.class, List.class}, (Object)object2, n)) {
            case 0 -> {
                Boolean ignored = (Boolean)object2;
                yield "boolean";
            }
            case 1 -> {
                Byte ignored = (Byte)object2;
                yield "byte";
            }
            case 2 -> {
                Character ignored = (Character)object2;
                yield "char";
            }
            case 3 -> {
                Short ignored = (Short)object2;
                yield "short";
            }
            case 4 -> {
                Integer ignored = (Integer)object2;
                yield "int";
            }
            case 5 -> {
                Long ignored = (Long)object2;
                yield "long";
            }
            case 6 -> {
                Float ignored = (Float)object2;
                yield "float";
            }
            case 7 -> {
                Double ignored = (Double)object2;
                yield "double";
            }
            case 8 -> {
                String ignored = (String)object2;
                yield "java.lang.String";
            }
            case 9 -> {
                Type ignored = (Type)object2;
                yield "java.lang.Class";
            }
            case 10 -> {
                String[] enumValue = (String[])object2;
                yield AnnotationsDataValidator.getSafeClassNameFromDesc(enumValue[0]);
            }
            case 11 -> {
                AnnotationNode annotation = (AnnotationNode)object2;
                yield AnnotationsDataValidator.getSafeClassNameFromDesc(annotation.desc);
            }
            case 12 -> {
                List ignored = (List)object2;
                yield "array";
            }
            default -> throw new AssertionError((Object)("Unexpected annotation value type: " + value.getClass().getName()));
        };
    }

    private static String getSafeClassNameFromDesc(String desc) {
        return desc.startsWith("L") && desc.endsWith(";") ? desc.substring(1, desc.length() - 1).replace('/', '.') : desc;
    }

    private static String typePathToString(@Nullable TypePath typePath) {
        return typePath == null ? "" : typePath.toString();
    }

    private static <T> List<T> concatLists(@Nullable List<T> list1, @Nullable List<T> list2) {
        ArrayList<T> result = new ArrayList<T>();
        if (list1 != null) {
            result.addAll(list1);
        }
        if (list2 != null) {
            result.addAll(list2);
        }
        return result;
    }

    @FunctionalInterface
    private static interface TypeAnnotationChecker {
        public boolean checkTypeAnnotation(TypeAnnotationNode var1);
    }
}

