/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.api.fmj;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.ApiStatus;

public abstract class FabricModJsonV1Spec {
    @Input
    public abstract Property<String> getModId();

    @Input
    public abstract Property<String> getVersion();

    @Input
    @Optional
    public abstract Property<String> getName();

    @Input
    @Optional
    public abstract Property<String> getDescription();

    @Input
    @Optional
    public abstract ListProperty<String> getProvides();

    @Input
    @Optional
    public abstract Property<String> getEnvironment();

    public void client() {
        this.getEnvironment().set((Object)"client");
    }

    public void server() {
        this.getEnvironment().set((Object)"server");
    }

    @Input
    @Optional
    public abstract ListProperty<Entrypoint> getEntrypoints();

    public void entrypoint(String entrypoint, String value) {
        this.entrypoint(entrypoint, value, (Action<Entrypoint>)((Action)metadata -> {}));
    }

    public void entrypoint(String entrypoint, String value, Action<Entrypoint> action) {
        this.entrypoint(entrypoint, (Action<Entrypoint>)((Action)metadata -> {
            metadata.getValue().set((Object)value);
            action.execute(metadata);
        }));
    }

    public void entrypoint(String entrypoint, Action<Entrypoint> action) {
        this.create(Entrypoint.class, this.getEntrypoints(), e -> {
            e.getEntrypoint().set((Object)entrypoint);
            action.execute(e);
        });
    }

    @Input
    @Optional
    public abstract ListProperty<String> getJars();

    @Input
    @Optional
    public abstract ListProperty<Mixin> getMixins();

    public void mixin(String value) {
        this.mixin(value, (Action<Mixin>)((Action)mixin -> {}));
    }

    public void mixin(String value, Action<Mixin> action) {
        this.mixin((Action<Mixin>)((Action)mixin -> {
            mixin.getValue().set((Object)value);
            action.execute(mixin);
        }));
    }

    public void mixin(Action<Mixin> action) {
        this.create(Mixin.class, this.getMixins(), action);
    }

    @Input
    @Optional
    public abstract Property<String> getAccessWidener();

    @Input
    @Optional
    public abstract ListProperty<Dependency> getDepends();

    public void depends(String modId, Iterable<String> versionRequirements) {
        this.depends(modId, (Action<Dependency>)((Action)dependency -> dependency.getVersionRequirements().addAll(versionRequirements)));
    }

    public void depends(String modId, String versionRequirement) {
        this.depends(modId, (Action<Dependency>)((Action)dependency -> dependency.getVersionRequirements().add((Object)versionRequirement)));
    }

    public void depends(String modId, Action<Dependency> action) {
        this.depends((Action<Dependency>)((Action)dependency -> {
            dependency.getModId().set((Object)modId);
            action.execute(dependency);
        }));
    }

    public void depends(Action<Dependency> action) {
        this.create(Dependency.class, this.getDepends(), action);
    }

    @Input
    @Optional
    public abstract ListProperty<Dependency> getRecommends();

    public void recommends(String modId, Iterable<String> versionRequirements) {
        this.recommends(modId, (Action<Dependency>)((Action)dependency -> dependency.getVersionRequirements().addAll(versionRequirements)));
    }

    public void recommends(String modId, String versionRequirement) {
        this.recommends(modId, (Action<Dependency>)((Action)dependency -> dependency.getVersionRequirements().add((Object)versionRequirement)));
    }

    public void recommends(String modId, Action<Dependency> action) {
        this.recommends((Action<Dependency>)((Action)dependency -> {
            dependency.getModId().set((Object)modId);
            action.execute(dependency);
        }));
    }

    public void recommends(Action<Dependency> action) {
        this.create(Dependency.class, this.getRecommends(), action);
    }

    @Input
    @Optional
    public abstract ListProperty<Dependency> getSuggests();

    public void suggests(String modId, Iterable<String> versionRequirements) {
        this.suggests(modId, (Action<Dependency>)((Action)dependency -> dependency.getVersionRequirements().addAll(versionRequirements)));
    }

    public void suggests(String modId, String versionRequirement) {
        this.suggests(modId, (Action<Dependency>)((Action)dependency -> dependency.getVersionRequirements().add((Object)versionRequirement)));
    }

    public void suggests(String modId, Action<Dependency> action) {
        this.suggests((Action<Dependency>)((Action)dependency -> {
            dependency.getModId().set((Object)modId);
            action.execute(dependency);
        }));
    }

    public void suggests(Action<Dependency> action) {
        this.create(Dependency.class, this.getSuggests(), action);
    }

    @Input
    @Optional
    public abstract ListProperty<Dependency> getConflicts();

    public void conflicts(String modId, Iterable<String> versionRequirements) {
        this.conflicts(modId, (Action<Dependency>)((Action)dependency -> dependency.getVersionRequirements().addAll(versionRequirements)));
    }

    public void conflicts(String modId, String versionRequirement) {
        this.conflicts(modId, (Action<Dependency>)((Action)dependency -> dependency.getVersionRequirements().add((Object)versionRequirement)));
    }

    public void conflicts(String modId, Action<Dependency> action) {
        this.conflicts((Action<Dependency>)((Action)dependency -> {
            dependency.getModId().set((Object)modId);
            action.execute(dependency);
        }));
    }

    public void conflicts(Action<Dependency> action) {
        this.create(Dependency.class, this.getConflicts(), action);
    }

    @Input
    @Optional
    public abstract ListProperty<Dependency> getBreaks();

    public void breaks(String modId, Iterable<String> versionRequirements) {
        this.breaks(modId, (Action<Dependency>)((Action)dependency -> dependency.getVersionRequirements().addAll(versionRequirements)));
    }

    public void breaks(String modId, String versionRequirement) {
        this.breaks(modId, (Action<Dependency>)((Action)dependency -> dependency.getVersionRequirements().add((Object)versionRequirement)));
    }

    public void breaks(String modId, Action<Dependency> action) {
        this.breaks((Action<Dependency>)((Action)dependency -> {
            dependency.getModId().set((Object)modId);
            action.execute(dependency);
        }));
    }

    public void breaks(Action<Dependency> action) {
        this.create(Dependency.class, this.getBreaks(), action);
    }

    @Input
    @Optional
    public abstract ListProperty<String> getLicenses();

    @Input
    @Optional
    public abstract ListProperty<Person> getAuthors();

    public void author(String name) {
        this.author(name, (Action<Person>)((Action)person -> {}));
    }

    public void author(String name, Action<Person> action) {
        this.author((Action<Person>)((Action)person -> {
            person.getName().set((Object)name);
            action.execute(person);
        }));
    }

    public void author(Action<Person> action) {
        this.create(Person.class, this.getAuthors(), action);
    }

    @Input
    @Optional
    public abstract ListProperty<Person> getContributors();

    public void contributor(String name) {
        this.contributor(name, (Action<Person>)((Action)person -> {}));
    }

    public void contributor(String name, Action<Person> action) {
        this.contributor((Action<Person>)((Action)person -> {
            person.getName().set((Object)name);
            action.execute(person);
        }));
    }

    public void contributor(Action<Person> action) {
        this.create(Person.class, this.getContributors(), action);
    }

    @Input
    @Optional
    public abstract MapProperty<String, String> getContactInformation();

    @Input
    @Optional
    public abstract ListProperty<Icon> getIcons();

    public void icon(String path) {
        this.icon(path, (Action<Icon>)((Action)icon -> {}));
    }

    public void icon(int size, String path) {
        this.icon(path, (Action<Icon>)((Action)icon -> icon.getSize().set((Object)size)));
    }

    public void icon(String path, Action<Icon> action) {
        this.icon((Action<Icon>)((Action)icon -> {
            icon.getPath().set((Object)path);
            action.execute(icon);
        }));
    }

    public void icon(Action<Icon> action) {
        this.create(Icon.class, this.getIcons(), action);
    }

    @Input
    @Optional
    public abstract MapProperty<String, String> getLanguageAdapters();

    @Input
    @Optional
    public abstract MapProperty<String, Object> getCustomData();

    @Inject
    @ApiStatus.Internal
    protected abstract ObjectFactory getObjectFactory();

    private <T> void create(Class<T> type, ListProperty<T> list, Action<T> action) {
        Object item = this.getObjectFactory().newInstance(type, new Object[0]);
        action.execute(item);
        list.add(item);
    }

    public static abstract class Entrypoint {
        @Input
        public abstract Property<String> getEntrypoint();

        @Input
        public abstract Property<String> getValue();

        @Input
        @Optional
        public abstract Property<String> getAdapter();
    }

    public static abstract class Mixin {
        @Input
        public abstract Property<String> getValue();

        @Input
        @Optional
        public abstract Property<String> getEnvironment();
    }

    public static abstract class Dependency {
        @Input
        public abstract Property<String> getModId();

        @Input
        @Optional
        public abstract ListProperty<String> getVersionRequirements();
    }

    public static abstract class Person {
        @Input
        public abstract Property<String> getName();

        @Input
        @Optional
        public abstract MapProperty<String, String> getContactInformation();
    }

    public static abstract class Icon {
        @Input
        public abstract Property<String> getPath();

        @Input
        @Optional
        public abstract Property<Integer> getSize();
    }
}

