/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.verify;

import java.io.IOException;
import java.nio.file.Path;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.fabricmc.loom.configuration.providers.minecraft.verify.CertificateChain;
import net.fabricmc.loom.configuration.providers.minecraft.verify.SignatureVerificationFailure;
import net.fabricmc.loom.util.ZipReprocessorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarVerifier.class);

    private JarVerifier() {
    }

    public static void verify(Path jarPath, CertificateChain certificateChain) throws IOException, SignatureVerificationFailure {
        Objects.requireNonNull(jarPath, "jarPath");
        Objects.requireNonNull(certificateChain, "certificateChain");
        if (certificateChain.issuer() != null) {
            throw new IllegalStateException("Can only verify jars from a root certificate");
        }
        HashSet<X509Certificate> jarCertificates = new HashSet<X509Certificate>();
        try (JarFile jarFile = new JarFile(jarPath.toFile(), true);){
            for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
                if (ZipReprocessorUtil.isSpecialFile(jarEntry.getName()) || jarEntry.getName().equals("META-INF/MANIFEST.MF") || jarEntry.isDirectory()) continue;
                try {
                    byte[] byArray = jarFile.getInputStream(jarEntry).readAllBytes();
                }
                catch (SecurityException e) {
                    throw new SignatureVerificationFailure("Jar entry " + jarEntry.getName() + " failed signature verification", e);
                }
                Certificate[] entryCertificates = jarEntry.getCertificates();
                if (entryCertificates == null) {
                    throw new SignatureVerificationFailure("Jar entry " + jarEntry.getName() + " does not have a signature");
                }
                Arrays.stream(entryCertificates).map(c -> (X509Certificate)c).forEach(jarCertificates::add);
            }
        }
        CertificateChain jarCertificateChain = CertificateChain.getRoot(jarCertificates);
        jarCertificateChain.verifyChainMatches(certificateChain);
        LOGGER.debug("Jar {} is signed by the expected certificate", (Object)jarPath);
    }
}

