/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.configuration.RemapConfigurations;
import net.fabricmc.loom.configuration.mods.ArtifactMetadata;
import net.fabricmc.loom.configuration.mods.ArtifactRef;
import net.fabricmc.loom.configuration.mods.ModProcessor;
import net.fabricmc.loom.configuration.mods.dependency.ModDependency;
import net.fabricmc.loom.configuration.mods.dependency.ModDependencyFactory;
import net.fabricmc.loom.configuration.mods.dependency.ModDependencyOptions;
import net.fabricmc.loom.util.AsyncCache;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.SourceRemapper;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import net.fabricmc.loom.util.service.ServiceFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.query.ArtifactResolutionQuery;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModConfigurationRemapper {
    public static final String MISSING_GROUP = "unspecified";
    private static final Logger LOGGER = LoggerFactory.getLogger(ModConfigurationRemapper.class);

    public static void supplyModConfigurations(Project project, ServiceFactory serviceFactory, String mappingsSuffix, LoomGradleExtension extension, SourceRemapper sourceRemapper) {
        DependencyHandler dependencies = project.getDependencies();
        LinkedHashMap<Configuration, Configuration> configsToRemap = new LinkedHashMap<Configuration, Configuration>();
        HashMap clientConfigsToRemap = new HashMap();
        List<RemapConfigurationSettings> remapConfigurationSettings = extension.getRemapConfigurations().stream().sorted(Comparator.comparing(setting -> !setting.getName().equals("modImplementation"))).toList();
        for (RemapConfigurationSettings entry : remapConfigurationSettings) {
            Map<Boolean, Boolean> envToEnabled = Map.of(false, (Boolean)entry.getOnCompileClasspath().get(), true, (Boolean)entry.getOnRuntimeClasspath().get());
            envToEnabled.forEach((runtime, enabled) -> {
                if (!enabled.booleanValue()) {
                    return;
                }
                Configuration target = RemapConfigurations.getOrCreateCollectorConfiguration(project, entry, (boolean)runtime);
                Configuration sourceCopy = ((Configuration)entry.getSourceConfiguration().get()).copyRecursive();
                Usage usage = (Usage)project.getObjects().named(Usage.class, runtime != false ? "java-runtime" : "java-api");
                sourceCopy.attributes(attributes -> attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)usage));
                sourceCopy.setCanBeConsumed(false);
                configsToRemap.put(sourceCopy, target);
                if (entry.getClientSourceConfigurationName().isPresent()) {
                    SourceSet clientSourceSet = SourceSetHelper.getSourceSetByName("client", project);
                    Configuration clientTarget = RemapConfigurations.getOrCreateCollectorConfiguration(project, clientSourceSet, (boolean)runtime);
                    clientConfigsToRemap.put(sourceCopy, clientTarget);
                }
            });
            if (!((String)entry.getTargetConfigurationName().get()).equals("api")) continue;
            Configuration remappedConfig2 = (Configuration)project.getConfigurations().maybeCreate(entry.getRemappedConfigurationName());
            remappedConfig2.setTransitive(false);
            project.getConfigurations().getByName("namedElements").extendsFrom(new Configuration[]{remappedConfig2});
            configsToRemap.put((Configuration)entry.getSourceConfiguration().get(), remappedConfig2);
        }
        ModDependencyOptions modDependencyOptions = ModDependencyOptions.create(project, ModDependencyOptions.class, options -> {
            options.getMappings().set((Object)mappingsSuffix);
            options.getInlineRefmap().set(extension.getMixin().getInlineDependencyRefmaps());
        });
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Mod dependency options: {}", (Object)modDependencyOptions.getJson());
        }
        HashMap dependenciesBySourceConfig = new HashMap();
        AsyncCache metaCache = new AsyncCache();
        configsToRemap.forEach((sourceConfig, remappedConfig) -> {
            Configuration clientRemappedConfig = (Configuration)clientConfigsToRemap.get(sourceConfig);
            List<ArtifactRef> artifactRefs = ModConfigurationRemapper.resolveArtifacts(project, sourceConfig);
            Map<ArtifactRef, ArtifactMetadata> metadataMap = ModConfigurationRemapper.getMetadata(artifactRefs, metaCache);
            ArrayList<ModDependency> modDependencies = new ArrayList<ModDependency>();
            for (ArtifactRef artifact : artifactRefs) {
                ArtifactMetadata artifactMetadata = Objects.requireNonNull(metadataMap.get(artifact), "Failed to find metadata for artifact");
                if (artifactMetadata.installerData() != null) {
                    if (extension.getInstallerData() != null) {
                        project.getLogger().info("Found another installer JSON in ({}), ignoring", (Object)artifact.path());
                    } else {
                        project.getLogger().info("Applying installer data from {}", (Object)artifact.path());
                        artifactMetadata.installerData().applyToProject(project);
                    }
                }
                if (!artifactMetadata.shouldRemap()) {
                    artifact.applyToConfiguration(project, (Configuration)remappedConfig);
                    continue;
                }
                ModDependency modDependency = ModDependencyFactory.create(artifact, artifactMetadata, remappedConfig, clientRemappedConfig, modDependencyOptions, project);
                ModConfigurationRemapper.scheduleSourcesRemapping(project, sourceRemapper, modDependency);
                modDependencies.add(modDependency);
            }
            dependenciesBySourceConfig.put(sourceConfig, modDependencies);
        });
        configsToRemap.forEach((sourceConfig, remappedConfig) -> {
            List modDependencies = (List)dependenciesBySourceConfig.get(sourceConfig);
            if (modDependencies.isEmpty()) {
                return;
            }
            Configuration clientRemappedConfig = (Configuration)clientConfigsToRemap.get(sourceConfig);
            boolean refreshDeps = LoomGradleExtension.get(project).refreshDeps();
            List<ModDependency> toRemap = modDependencies.stream().filter(dependency -> refreshDeps || dependency.isCacheInvalid(project, null)).toList();
            if (!toRemap.isEmpty()) {
                try {
                    new ModProcessor(project, (Configuration)sourceConfig, serviceFactory).processMods(toRemap);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to remap mods", e);
                }
            }
            for (ModDependency info : modDependencies) {
                info.applyToProject(project);
                ModConfigurationRemapper.createConstraints(info.getInputArtifact(), remappedConfig, sourceConfig, dependencies);
                if (clientRemappedConfig == null) continue;
                ModConfigurationRemapper.createConstraints(info.getInputArtifact(), clientRemappedConfig, sourceConfig, dependencies);
            }
        });
    }

    private static Map<ArtifactRef, ArtifactMetadata> getMetadata(List<ArtifactRef> artifacts, AsyncCache<ArtifactMetadata> cache) {
        HashMap<ArtifactRef, CompletableFuture<ArtifactMetadata>> futures = new HashMap<ArtifactRef, CompletableFuture<ArtifactMetadata>>();
        for (ArtifactRef artifact : artifacts) {
            CompletableFuture<ArtifactMetadata> future = cache.get(artifact, () -> {
                try {
                    return ArtifactMetadata.create(artifact, LoomGradlePlugin.LOOM_VERSION);
                }
                catch (IOException e) {
                    throw ExceptionUtil.createDescriptiveWrapper(UncheckedIOException::new, "Failed to read metadata from " + String.valueOf(artifact.path()), e);
                }
            });
            futures.put(artifact, future);
        }
        return AsyncCache.joinMap(futures);
    }

    private static void createConstraints(ArtifactRef artifact, Configuration targetConfig, Configuration sourceConfig, DependencyHandler dependencies) {
    }

    private static List<ArtifactRef> resolveArtifacts(Project project, Configuration configuration) {
        ArrayList<ArtifactRef> artifacts = new ArrayList<ArtifactRef>();
        Set resolvedArtifacts = configuration.getResolvedConfiguration().getResolvedArtifacts();
        Map<ResolvedArtifact, Path> sourcesMap = ModConfigurationRemapper.downloadAllSources(project, resolvedArtifacts);
        for (ResolvedArtifact artifact : resolvedArtifacts) {
            @Nullable Path sources = sourcesMap.get(artifact);
            artifacts.add(new ArtifactRef.ResolvedArtifactRef(artifact, sources));
        }
        for (FileCollectionDependency dependency : configuration.getAllDependencies().withType(FileCollectionDependency.class)) {
            String group = ModConfigurationRemapper.replaceIfNullOrEmpty(dependency.getGroup(), () -> MISSING_GROUP);
            FileCollection files = dependency.getFiles();
            for (File artifact : files) {
                String name = ModConfigurationRemapper.getNameWithoutExtension(artifact.toPath());
                String version = ModConfigurationRemapper.replaceIfNullOrEmpty(dependency.getVersion(), () -> Checksum.of(artifact).sha256().hex(10));
                artifacts.add(new ArtifactRef.FileArtifactRef(artifact.toPath(), group, name, version));
            }
        }
        return artifacts;
    }

    private static String getNameWithoutExtension(Path file) {
        String fileName = file.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    private static Map<ResolvedArtifact, Path> downloadAllSources(Project project, Set<ResolvedArtifact> resolvedArtifacts) {
        if (ModConfigurationRemapper.isCIBuild()) {
            return Map.of();
        }
        DependencyHandler dependencies = project.getDependencies();
        List<ComponentIdentifier> componentIdentifiers = resolvedArtifacts.stream().map(ResolvedArtifact::getId).map(ComponentArtifactIdentifier::getComponentIdentifier).toList();
        ArtifactResolutionQuery query = dependencies.createArtifactResolutionQuery().forComponents(componentIdentifiers).withArtifacts(JvmLibrary.class, new Class[]{SourcesArtifact.class});
        Set resolvedSources = query.execute().getResolvedComponents();
        HashMap<ResolvedArtifact, Path> sources = new HashMap<ResolvedArtifact, Path>();
        for (ResolvedArtifact resolvedArtifact : resolvedArtifacts) {
            for (ComponentArtifactsResult sourceArtifact : resolvedSources) {
                Path sourcesPath;
                if (!sourceArtifact.getId().equals((Object)resolvedArtifact.getId().getComponentIdentifier()) || (sourcesPath = ModConfigurationRemapper.getSourcesPath(sourceArtifact)) == null) continue;
                sources.put(resolvedArtifact, sourcesPath);
            }
        }
        return sources;
    }

    private static Path getSourcesPath(ComponentArtifactsResult sourceArtifact) {
        for (ArtifactResult srcArtifact : sourceArtifact.getArtifacts(SourcesArtifact.class)) {
            if (!(srcArtifact instanceof ResolvedArtifactResult)) continue;
            return ((ResolvedArtifactResult)srcArtifact).getFile().toPath();
        }
        return null;
    }

    private static void scheduleSourcesRemapping(Project project, SourceRemapper sourceRemapper, ModDependency dependency) {
        if (ModConfigurationRemapper.isCIBuild()) {
            return;
        }
        Path sourcesInput = dependency.getInputArtifact().sources();
        if (sourcesInput == null || Files.notExists(sourcesInput, new LinkOption[0])) {
            return;
        }
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (dependency.isCacheInvalid(project, "sources") || extension.refreshDeps()) {
            Path output = dependency.getWorkingFile(project, "sources");
            sourceRemapper.scheduleRemapSources(sourcesInput.toFile(), output.toFile(), false, true, () -> {
                try {
                    dependency.copyToCache(project, output, "sources");
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to apply sources to local cache for: " + String.valueOf(dependency), e);
                }
            });
        }
    }

    public static String replaceIfNullOrEmpty(@Nullable String s, Supplier<String> fallback) {
        return s == null || s.isEmpty() ? fallback.get() : s;
    }

    private static boolean isCIBuild() {
        String loomProperty = System.getProperty("fabric.loom.ci");
        if (loomProperty != null) {
            return loomProperty.equalsIgnoreCase("true");
        }
        return System.getenv("CI") != null;
    }

    private static /* synthetic */ void lambda$createConstraints$8(Configuration targetConfig, Configuration sourceConfig, DependencyConstraint constraint) {
        constraint.because("configuration (%s) already contains the remapped module from configuration (%s)".formatted(targetConfig.getName(), sourceConfig.getName()));
        constraint.version(MutableVersionConstraint::rejectAll);
    }
}

