/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.kotlin;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.kotlin.remapping.KotlinMetadataTinyRemapperExtensionImpl;
import net.fabricmc.loom.util.kotlin.KotlinClasspath;
import net.fabricmc.loom.util.kotlin.KotlinMetadataTinyRemapperExtension;

public class KotlinRemapperClassloader
extends URLClassLoader {
    private static final List<String> PARENT_PACKAGES = List.of("net.fabricmc.tinyremapper", "net.fabricmc.loom.util.kotlin", "org.objectweb.asm", "org.slf4j");

    private KotlinRemapperClassloader(URL[] urls) {
        super(urls, (ClassLoader)null);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (PARENT_PACKAGES.stream().anyMatch(name::startsWith)) {
            return LoomGradlePlugin.class.getClassLoader().loadClass(name);
        }
        return super.loadClass(name, resolve);
    }

    public static KotlinRemapperClassloader create(KotlinClasspath classpathProvider) {
        Stream<URL> loomUrls = KotlinRemapperClassloader.getClassUrls(KotlinMetadataTinyRemapperExtensionImpl.class);
        URL[] urls = (URL[])Stream.concat(loomUrls, classpathProvider.classpath().stream()).toArray(URL[]::new);
        return new KotlinRemapperClassloader(urls);
    }

    private static Stream<URL> getClassUrls(Class<?> ... classes) {
        return Arrays.stream(classes).map(klass -> klass.getProtectionDomain().getCodeSource().getLocation());
    }

    public KotlinMetadataTinyRemapperExtension getTinyRemapperExtension() {
        try {
            Class<?> klass = this.loadClass(KotlinMetadataTinyRemapperExtensionImpl.class.getCanonicalName());
            return (KotlinMetadataTinyRemapperExtension)klass.getField("INSTANCE").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to create instance", e);
        }
    }
}

