/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.fmj.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.util.fmj.FabricModJsonSource;

public record MixinRefmap(String refmapPath, MixinMappingData mappings, Map<NamespacePair, MixinMappingData> data) {
    private static final String MAPPINGS_KEY = "mappings";
    private static final String DATA_KEY = "data";

    public static MixinRefmap fromMod(String refmapPath, FabricModJsonSource modSource) throws IOException {
        String refmapJson = new String(modSource.read(refmapPath));
        JsonObject jsonObject = (JsonObject)LoomGradlePlugin.GSON.fromJson(refmapJson, JsonObject.class);
        MixinMappingData mappings = MixinMappingData.EMPTY;
        HashMap<NamespacePair, MixinMappingData> data = new HashMap<NamespacePair, MixinMappingData>();
        if (jsonObject.has(MAPPINGS_KEY)) {
            mappings = MixinMappingData.parse(jsonObject.getAsJsonObject(MAPPINGS_KEY));
        }
        if (jsonObject.has(DATA_KEY)) {
            JsonObject dataJson = jsonObject.getAsJsonObject(DATA_KEY);
            for (Map.Entry entry : dataJson.entrySet()) {
                String namespaces = (String)entry.getKey();
                JsonObject namespacedData = ((JsonElement)entry.getValue()).getAsJsonObject();
                data.put(NamespacePair.parseString(namespaces), MixinMappingData.parse(namespacedData));
            }
        }
        return new MixinRefmap(refmapPath, mappings, data);
    }

    public MixinMappingData getData(NamespacePair namespaces) {
        MixinMappingData data = this.data.get(namespaces);
        if (data != null) {
            return data;
        }
        return this.mappings;
    }

    public record MixinMappingData(Map<String, ReferenceMappingData> data) {
        private static final MixinMappingData EMPTY = new MixinMappingData(Map.of());

        private static MixinMappingData parse(JsonObject jsonObject) {
            HashMap<String, ReferenceMappingData> data = new HashMap<String, ReferenceMappingData>();
            for (Map.Entry entry : jsonObject.entrySet()) {
                String mixinName = (String)entry.getKey();
                JsonObject mappings = ((JsonElement)entry.getValue()).getAsJsonObject();
                data.put(mixinName, ReferenceMappingData.parse(mappings));
            }
            return new MixinMappingData(data);
        }

        public String remap(String mixinName, String reference) {
            ReferenceMappingData referenceMappingData = this.data.get(mixinName);
            if (referenceMappingData == null) {
                return reference;
            }
            return referenceMappingData.remap(reference);
        }
    }

    public record NamespacePair(String from, String to) {
        private static NamespacePair parseString(String string) {
            String[] parts = string.split(":");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid namespace pair: " + string);
            }
            return new NamespacePair(parts[0], parts[1]);
        }
    }

    public record ReferenceMappingData(Map<String, String> mappings) {
        private static ReferenceMappingData parse(JsonObject jsonObject) {
            HashMap<String, String> mappings = new HashMap<String, String>();
            for (Map.Entry entry : jsonObject.entrySet()) {
                mappings.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            return new ReferenceMappingData(mappings);
        }

        public String remap(String reference) {
            return this.mappings.getOrDefault(reference, reference);
        }
    }
}

