/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.library.processors;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.loom.configuration.providers.minecraft.library.Library;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryContext;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryProcessor;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.loom.util.Platform;

public class LoomNativeSupportLibraryProcessor
extends LibraryProcessor {
    public LoomNativeSupportLibraryProcessor(Platform platform, LibraryContext context) {
        super(platform, context);
    }

    @Override
    public LibraryProcessor.ApplicationResult getApplicationResult() {
        if (!this.context.usesLWJGL3()) {
            return LibraryProcessor.ApplicationResult.DONT_APPLY;
        }
        if (this.platform.getOperatingSystem().isMacOS() && this.platform.getArchitecture().isArm() && !this.context.supportsArm64(Platform.OperatingSystem.MAC_OS)) {
            return LibraryProcessor.ApplicationResult.MUST_APPLY;
        }
        return LibraryProcessor.ApplicationResult.CAN_APPLY;
    }

    @Override
    public Predicate<Library> apply(Consumer<Library> dependencyConsumer) {
        dependencyConsumer.accept(Library.fromMaven(LoomVersions.NATIVE_SUPPORT.mavenNotation(), Library.Target.LOCAL_MOD));
        return ALLOW_ALL;
    }
}

