/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.fmj.gen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.api.fmj.FabricModJsonV1Spec;
import net.fabricmc.loom.util.fmj.gen.FabricModJsonGenerator;
import net.fabricmc.loom.util.fmj.gen.GeneratorUtils;

public final class FabricModJsonV1Generator
implements FabricModJsonGenerator<FabricModJsonV1Spec> {
    private static final int VERSION = 1;
    public static final FabricModJsonV1Generator INSTANCE = new FabricModJsonV1Generator();

    private FabricModJsonV1Generator() {
    }

    @Override
    public String generate(FabricModJsonV1Spec spec) {
        Objects.requireNonNull(spec);
        JsonObject fmj = new JsonObject();
        fmj.addProperty("schemaVersion", (Number)1);
        GeneratorUtils.addRequired(fmj, "id", spec.getModId());
        GeneratorUtils.addRequired(fmj, "version", spec.getVersion());
        GeneratorUtils.addArray(fmj, "provides", spec.getProvides(), JsonPrimitive::new);
        GeneratorUtils.add(fmj, "environment", spec.getEnvironment());
        GeneratorUtils.add(fmj, "entrypoints", spec.getEntrypoints(), this::generateEntrypoints);
        GeneratorUtils.addArray(fmj, "jars", spec.getJars(), this::generateJar);
        GeneratorUtils.addArray(fmj, "mixins", spec.getMixins(), this::generateMixins);
        GeneratorUtils.add(fmj, "accessWidener", spec.getAccessWidener());
        GeneratorUtils.add(fmj, "depends", spec.getDepends(), this::generateDependencies);
        GeneratorUtils.add(fmj, "recommends", spec.getRecommends(), this::generateDependencies);
        GeneratorUtils.add(fmj, "suggests", spec.getSuggests(), this::generateDependencies);
        GeneratorUtils.add(fmj, "conflicts", spec.getConflicts(), this::generateDependencies);
        GeneratorUtils.add(fmj, "breaks", spec.getBreaks(), this::generateDependencies);
        GeneratorUtils.add(fmj, "name", spec.getName());
        GeneratorUtils.add(fmj, "description", spec.getDescription());
        GeneratorUtils.addArray(fmj, "authors", spec.getAuthors(), this::generatePerson);
        GeneratorUtils.addArray(fmj, "contributors", spec.getContributors(), this::generatePerson);
        GeneratorUtils.add(fmj, "contact", spec.getContactInformation());
        GeneratorUtils.addStringOrArray(fmj, "license", spec.getLicenses());
        GeneratorUtils.add(fmj, "icon", spec.getIcons(), this::generateIcon);
        GeneratorUtils.add(fmj, "languageAdapters", spec.getLanguageAdapters());
        GeneratorUtils.add(fmj, "custom", spec.getCustomData(), this::generateCustomData);
        return LoomGradlePlugin.GSON.toJson((JsonElement)fmj);
    }

    private JsonElement generatePerson(FabricModJsonV1Spec.Person person) {
        if (((Map)person.getContactInformation().get()).isEmpty()) {
            return new JsonPrimitive((String)person.getName().get());
        }
        JsonObject json = new JsonObject();
        GeneratorUtils.addRequired(json, "name", person.getName());
        GeneratorUtils.add(json, "contact", person.getContactInformation());
        return json;
    }

    private JsonObject generateEntrypoints(List<FabricModJsonV1Spec.Entrypoint> entrypoints) {
        Map<String, List<FabricModJsonV1Spec.Entrypoint>> entrypointsMap = entrypoints.stream().collect(Collectors.groupingBy(entrypoint -> (String)entrypoint.getEntrypoint().get()));
        JsonObject json = new JsonObject();
        entrypointsMap.forEach((entrypoint, entries) -> json.add(entrypoint, (JsonElement)this.generateEntrypoint((List<FabricModJsonV1Spec.Entrypoint>)entries)));
        return json;
    }

    private JsonArray generateEntrypoint(List<FabricModJsonV1Spec.Entrypoint> entries) {
        JsonArray json = new JsonArray();
        for (FabricModJsonV1Spec.Entrypoint entry : entries) {
            json.add(this.generateEntrypointEntry(entry));
        }
        return json;
    }

    private JsonElement generateEntrypointEntry(FabricModJsonV1Spec.Entrypoint entrypoint) {
        if (!entrypoint.getAdapter().isPresent()) {
            return new JsonPrimitive((String)entrypoint.getValue().get());
        }
        JsonObject json = new JsonObject();
        GeneratorUtils.addRequired(json, "value", entrypoint.getValue());
        GeneratorUtils.addRequired(json, "adapter", entrypoint.getAdapter());
        return json;
    }

    private JsonObject generateJar(String jar) {
        JsonObject json = new JsonObject();
        json.addProperty("file", jar);
        return json;
    }

    private JsonElement generateMixins(FabricModJsonV1Spec.Mixin mixin) {
        if (!mixin.getEnvironment().isPresent()) {
            return new JsonPrimitive((String)mixin.getValue().get());
        }
        JsonObject json = new JsonObject();
        GeneratorUtils.addRequired(json, "config", mixin.getValue());
        GeneratorUtils.addRequired(json, "environment", mixin.getEnvironment());
        return json;
    }

    private JsonObject generateDependencies(List<FabricModJsonV1Spec.Dependency> dependencies) {
        JsonObject json = new JsonObject();
        for (FabricModJsonV1Spec.Dependency dependency : dependencies) {
            json.add((String)dependency.getModId().get(), this.generateDependency(dependency));
        }
        return json;
    }

    private JsonElement generateDependency(FabricModJsonV1Spec.Dependency dependency) {
        List requirements = (List)dependency.getVersionRequirements().get();
        if (requirements.isEmpty()) {
            throw new IllegalStateException("Dependency " + (String)dependency.getModId().get() + " must have at least one version requirement");
        }
        if (requirements.size() == 1) {
            return new JsonPrimitive((String)dependency.getModId().get());
        }
        JsonArray json = new JsonArray();
        for (String s : requirements) {
            json.add(s);
        }
        return json;
    }

    private JsonElement generateIcon(List<FabricModJsonV1Spec.Icon> icons) {
        if (icons.size() == 1 && !icons.getFirst().getSize().isPresent()) {
            return new JsonPrimitive((String)icons.getFirst().getPath().get());
        }
        JsonObject json = new JsonObject();
        for (FabricModJsonV1Spec.Icon icon : icons) {
            String size = String.valueOf(icon.getSize().get());
            json.addProperty(size, (String)icon.getPath().get());
        }
        return json;
    }

    private JsonObject generateCustomData(Map<String, Object> customData) {
        JsonObject json = new JsonObject();
        customData.forEach((name, o) -> json.add(name, LoomGradlePlugin.GSON.toJsonTree(o)));
        return json;
    }
}

