/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.util.Locale;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;

public final class SidedClassVisitor
extends ClassVisitor {
    public static final TinyRemapper.ApplyVisitorProvider CLIENT = (cls, next) -> new SidedClassVisitor("client", next);
    public static final TinyRemapper.ApplyVisitorProvider SERVER = (cls, next) -> new SidedClassVisitor("server", next);
    private static final String ENVIRONMENT_DESCRIPTOR = "Lnet/fabricmc/api/Environment;";
    private static final String SIDE_DESCRIPTOR = "Lnet/fabricmc/api/EnvType;";
    private final String side;
    private boolean hasExisting = false;

    private SidedClassVisitor(String side, ClassVisitor next) {
        super(589824, next);
        this.side = side;
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if (ENVIRONMENT_DESCRIPTOR.equals(descriptor)) {
            this.hasExisting = true;
        }
        return super.visitAnnotation(descriptor, visible);
    }

    public void visitEnd() {
        if (!this.hasExisting) {
            AnnotationVisitor annotationVisitor = this.visitAnnotation(ENVIRONMENT_DESCRIPTOR, true);
            annotationVisitor.visitEnum("value", SIDE_DESCRIPTOR, this.side.toUpperCase(Locale.ROOT));
            annotationVisitor.visitEnd();
        }
        super.visitEnd();
    }
}

