/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.WarningMode;

public interface DeprecationHelper {
    default public void replaceWithInLoom2_0(String currentName, String newName) {
        this.toBeRemovedIn(currentName, newName, "Loom 2.0");
    }

    default public void removedInLoom2_0(String currentName) {
        this.toBeRemovedIn(currentName, "Loom 2.0");
    }

    default public void toBeRemovedIn(String currentName, String newName, String removalVersion) {
        this.warn("The '%s' property has been deprecated, and has been replaced with '%s'. This is scheduled to be removed in %s.".formatted(currentName, newName, removalVersion));
    }

    default public void toBeRemovedIn(String currentName, String removalVersion) {
        this.warn("The '%s' property has been deprecated, and can be removed. This is scheduled to be removed in %s.".formatted(currentName, removalVersion));
    }

    public Project getProject();

    public void warn(String var1);

    public static class ProjectBased
    implements DeprecationHelper {
        private final Project project;
        private final AtomicBoolean usingDeprecatedApi = new AtomicBoolean(false);

        public ProjectBased(Project project) {
            this.project = project;
        }

        @Override
        public Project getProject() {
            return this.project;
        }

        @Override
        public void warn(String warning) {
            WarningMode warningMode = this.getProject().getGradle().getStartParameter().getWarningMode();
            this.getProject().getLogger().log(warningMode == WarningMode.None ? LogLevel.INFO : LogLevel.WARN, warning);
            if (warningMode == WarningMode.Fail) {
                throw new UnsupportedOperationException(warning);
            }
            this.usingDeprecatedApi.set(true);
        }
    }
}

