/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.vineflower;

import java.io.IOException;
import net.fabricmc.loom.decompilers.LoomInternalDecompiler;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;

public class VineflowerLogger
extends IFernflowerLogger {
    private final LoomInternalDecompiler.Logger logger;

    public VineflowerLogger(LoomInternalDecompiler.Logger logger) {
        this.logger = logger;
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity) {
        if (severity.ordinal() < IFernflowerLogger.Severity.ERROR.ordinal()) {
            return;
        }
        System.err.println(message);
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity, Throwable t) {
        if (severity.ordinal() < IFernflowerLogger.Severity.ERROR.ordinal()) {
            return;
        }
        this.writeMessage(message, severity);
        t.printStackTrace(System.err);
    }

    private void write(String data) {
        try {
            this.logger.accept(data);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to log", e);
        }
    }

    public void startReadingClass(String className) {
        this.write("Decompiling " + className);
    }

    public void startClass(String className) {
        this.write("Decompiling " + className);
    }

    public void startWriteClass(String className) {
    }

    public void startMethod(String methodName) {
    }

    public void endMethod() {
    }
}

