/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loom.util.Platform;
import org.jetbrains.annotations.Nullable;

public record MinecraftVersionMeta(Object arguments, AssetIndex assetIndex, String assets, int complianceLevel, Map<String, Download> downloads, String id, List<Library> libraries, Object logging, String mainClass, int minimumLauncherVersion, String releaseTime, String time, String type, @Nullable JavaVersion javaVersion) {
    private static Map<Platform.OperatingSystem, String> OS_NAMES = Map.of(Platform.OperatingSystem.WINDOWS, "windows", Platform.OperatingSystem.MAC_OS, "osx", Platform.OperatingSystem.LINUX, "linux");

    public Download download(String key) {
        return this.downloads().get(key);
    }

    public boolean isVersionOrNewer(String releaseTime) {
        return this.releaseTime().compareTo(releaseTime) >= 0;
    }

    public boolean isLegacyVersion() {
        return !this.isVersionOrNewer("2012-07-25T22:00:00+00:00");
    }

    public boolean hasClient() {
        return this.downloads().containsKey("client");
    }

    public boolean hasServer() {
        return this.downloads().containsKey("server");
    }

    public boolean isLegacySplitOfficialNamespaceVersion() {
        return this.isLegacyVersion() && this.isVersionOrNewer("2010-12-19T22:00:00+00:00");
    }

    public boolean hasNativesToExtract() {
        return this.libraries.stream().anyMatch(Library::hasNatives);
    }

    public record AssetIndex(String id, long totalSize, String path, String sha1, long size, String url) {
        public String fabricId(String version) {
            return this.id.equals(version) ? version : version + "-" + this.id;
        }
    }

    public record JavaVersion(String component, int majorVersion) {
    }

    public record Download(String path, String sha1, long size, String url) {
        public File relativeFile(File baseDirectory) {
            Objects.requireNonNull(this.path(), "Cannot get relative file from a null path");
            return new File(baseDirectory, this.path());
        }
    }

    public record OS(String name) {
        public boolean isValidForOS(Platform platform) {
            return this.name() == null || this.name().equalsIgnoreCase(OS_NAMES.get((Object)platform.getOperatingSystem()));
        }
    }

    public record Rule(String action, OS os) {
        public boolean appliesToOS(Platform platform) {
            return this.os() == null || this.os().isValidForOS(platform);
        }

        public boolean isAllowed() {
            return this.action().equals("allow");
        }
    }

    public record Downloads(Download artifact, Map<String, Download> classifiers) {
        @Nullable
        public Download classifier(String os) {
            return this.classifiers.get(os);
        }
    }

    public record Library(Downloads downloads, String name, Map<String, String> natives, List<Rule> rules, Object extract) {
        public boolean isValidForOS(Platform platform) {
            if (this.rules == null) {
                return true;
            }
            boolean valid = false;
            for (Rule rule : this.rules) {
                if (!rule.appliesToOS(platform)) continue;
                valid = rule.isAllowed();
            }
            return valid;
        }

        public boolean hasNatives() {
            return this.natives != null;
        }

        public boolean hasNativesForOS(Platform platform) {
            if (!this.hasNatives()) {
                return false;
            }
            if (this.classifierForOS(platform) == null) {
                return false;
            }
            return this.isValidForOS(platform);
        }

        @Nullable
        public Download classifierForOS(Platform platform) {
            Download armNative;
            String classifier = this.natives.get(OS_NAMES.get((Object)platform.getOperatingSystem()));
            if (classifier == null) {
                return null;
            }
            if (platform.getArchitecture().isArm() && platform.getArchitecture().is64Bit() && (armNative = this.downloads().classifier(classifier + "-arm64")) != null) {
                return armNative;
            }
            classifier = classifier.replace("${arch}", platform.getArchitecture().is64Bit() ? "64" : "32");
            return this.downloads().classifier(classifier);
        }

        public Download artifact() {
            if (this.downloads() == null) {
                return null;
            }
            return this.downloads().artifact();
        }
    }
}

