/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.extras.annotations.validate;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureVisitor;

public final class TypePathCheckerVisitor
extends SignatureVisitor {
    private final TypePath path;
    private final int pathLen;
    private int pathIndex = 0;
    private boolean reached = false;
    private String error = null;
    private final Deque<Integer> argIndexStack = new ArrayDeque<Integer>();
    private final SignatureVisitor sink = new SignatureVisitor(this, 589824){};

    public TypePathCheckerVisitor(TypePath path) {
        super(589824);
        this.path = path;
        int n = this.pathLen = path == null ? 0 : path.getLength();
        if (this.pathLen == 0) {
            this.reached = true;
        }
    }

    private boolean hasMoreSteps() {
        return this.pathIndex < this.pathLen;
    }

    private int nextStepKind() {
        return this.path.getStep(this.pathIndex);
    }

    private int nextStepArgumentIndex() {
        return this.path.getStepArgument(this.pathIndex);
    }

    private String stepRepr(int i) {
        return switch (this.path.getStep(i)) {
            case 0 -> "[";
            case 1 -> ".";
            case 2 -> "*";
            case 3 -> this.path.getStepArgument(i) + ";";
            default -> throw new AssertionError((Object)("Unexpected type path step kind: " + this.path.getStep(i)));
        };
    }

    private String remainingSteps() {
        if (this.path == null || !this.hasMoreSteps()) {
            return "<none>";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = this.pathIndex; i < this.pathLen; ++i) {
            sb.append(this.stepRepr(i));
        }
        return sb.toString();
    }

    private void consumeStep() {
        ++this.pathIndex;
        if (this.pathIndex == this.pathLen) {
            this.reached = true;
        }
    }

    @Nullable
    public String getError() {
        if (this.error != null) {
            return this.error;
        }
        if (!this.reached) {
            return "TypePath not fully consumed at index " + this.pathIndex + ", remaining steps: '" + this.remainingSteps() + "'";
        }
        return null;
    }

    public void visitBaseType(char descriptor) {
        if (this.hasMoreSteps()) {
            this.error = "TypePath has extra steps starting at index " + this.pathIndex + " ('" + this.remainingSteps() + "') but reached base type descriptor '" + descriptor + "'.";
        } else {
            this.reached = true;
        }
    }

    public void visitTypeVariable(String name) {
        if (this.hasMoreSteps()) {
            this.error = "TypePath has extra steps starting at index " + this.pathIndex + " ('" + this.remainingSteps() + "') but reached type variable '" + name + "'.";
        } else {
            this.reached = true;
        }
    }

    public SignatureVisitor visitArrayType() {
        if (this.hasMoreSteps()) {
            if (this.nextStepKind() == 0) {
                this.consumeStep();
            } else {
                this.error = "At step " + this.pathIndex + " expected array element '[' but found '" + this.stepRepr(this.pathIndex) + "'.";
            }
        }
        return this;
    }

    public void visitClassType(String name) {
        this.argIndexStack.push(0);
        String[] innerParts = name.split("\\$");
        for (int i = 1; i < innerParts.length; ++i) {
            this.visitInnerClassType(innerParts[i]);
        }
    }

    public void visitInnerClassType(String name) {
        if (this.hasMoreSteps()) {
            if (this.nextStepKind() == 1) {
                this.consumeStep();
            } else {
                this.error = "At step " + this.pathIndex + " expected inner type '.' but found '" + this.stepRepr(this.pathIndex) + "'.";
            }
        }
        this.argIndexStack.push(0);
    }

    public void visitTypeArgument() {
        boolean targeted;
        if (this.error != null) {
            return;
        }
        if (this.argIndexStack.isEmpty()) {
            this.error = "Type signature has no enclosing class type for an unbounded wildcard at step " + this.pathIndex + ".";
            return;
        }
        int idx = this.argIndexStack.pop();
        boolean bl = targeted = this.hasMoreSteps() && this.nextStepKind() == 3 && this.nextStepArgumentIndex() == idx;
        if (targeted) {
            this.consumeStep();
            if (this.hasMoreSteps()) {
                this.error = "TypePath targets unbounded wildcard '*' at step " + (this.pathIndex - 1) + " but contains further steps; '*' is terminal.";
            } else {
                this.reached = true;
            }
        }
        this.argIndexStack.push(idx + 1);
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        boolean targeted;
        if (this.error != null) {
            return this.sink;
        }
        if (this.argIndexStack.isEmpty()) {
            this.error = "Type signature has no enclosing class type for a type argument at step " + this.pathIndex + ".";
            return this.sink;
        }
        int idx = this.argIndexStack.pop();
        boolean bl = targeted = this.hasMoreSteps() && this.nextStepKind() == 3 && this.nextStepArgumentIndex() == idx;
        if (targeted) {
            this.consumeStep();
            if (this.pathIndex == this.pathLen) {
                this.argIndexStack.push(idx + 1);
                return this.sink;
            }
        }
        this.argIndexStack.push(idx + 1);
        if (this.hasMoreSteps() && this.nextStepKind() == 2) {
            if (wildcard == '+' || wildcard == '-') {
                this.consumeStep();
            } else {
                this.error = "At step " + this.pathIndex + " found wildcard bound '*' but the type argument is exact ('=').";
            }
        }
        return this;
    }

    public void visitEnd() {
        if (this.argIndexStack.isEmpty()) {
            if (this.error == null) {
                this.error = "visitEnd encountered with no matching class/inner-class at step " + this.pathIndex + ".";
            }
        } else {
            this.argIndexStack.pop();
        }
    }
}

