/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.fabricapi;

import java.io.File;
import java.util.HashSet;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.fabricapi.DataGenerationSettings;
import net.fabricmc.loom.configuration.fabricapi.FabricApiAbstractSourceSet;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.jvm.tasks.Jar;

public abstract class FabricApiDataGeneration
extends FabricApiAbstractSourceSet {
    @Override
    @Inject
    protected abstract Project getProject();

    @Inject
    public FabricApiDataGeneration() {
    }

    @Override
    protected String getSourceSetName() {
        return "datagen";
    }

    void configureDataGeneration(Action<DataGenerationSettings> action) {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        TaskContainer taskContainer = this.getProject().getTasks();
        DataGenerationSettings settings = (DataGenerationSettings)this.getProject().getObjects().newInstance(DataGenerationSettings.class, new Object[0]);
        settings.getOutputDirectory().set(this.getProject().file((Object)"src/main/generated"));
        settings.getCreateRunConfiguration().convention((Object)true);
        settings.getCreateSourceSet().convention((Object)false);
        settings.getStrictValidation().convention((Object)false);
        settings.getAddToResources().convention((Object)true);
        settings.getClient().convention((Object)false);
        action.execute((Object)settings);
        SourceSet mainSourceSet = SourceSetHelper.getMainSourceSet(this.getProject());
        File outputDirectory = (File)settings.getOutputDirectory().getAsFile().get();
        if (((Boolean)settings.getAddToResources().get()).booleanValue()) {
            mainSourceSet.resources(files -> {
                HashSet<File> srcDirs = new HashSet<File>(files.getSrcDirs());
                srcDirs.add(outputDirectory);
                files.setSrcDirs(srcDirs);
            });
        }
        taskContainer.getByName("jar", task -> {
            Jar jar = (Jar)task;
            jar.exclude(new String[]{".cache/**"});
        });
        if (((Boolean)settings.getCreateSourceSet().get()).booleanValue()) {
            this.configureSourceSet(settings.getModId(), (Boolean)settings.getClient().get());
        }
        if (((Boolean)settings.getCreateRunConfiguration().get()).booleanValue()) {
            extension.getRunConfigs().create("datagen", run -> {
                run.inherit((RunConfigSettings)extension.getRunConfigs().getByName((Boolean)settings.getClient().get() != false ? "client" : "server"));
                run.setConfigName("Data Generation");
                run.property("fabric-api.datagen");
                run.property("fabric-api.datagen.output-dir", outputDirectory.getAbsolutePath());
                run.runDir("build/datagen");
                if (settings.getModId().isPresent()) {
                    run.property("fabric-api.datagen.modid", (String)settings.getModId().get());
                }
                if (((Boolean)settings.getStrictValidation().get()).booleanValue()) {
                    run.property("fabric-api.datagen.strict-validation", "true");
                }
                if (((Boolean)settings.getCreateSourceSet().get()).booleanValue()) {
                    run.source(this.getSourceSetName());
                }
            });
            this.getProject().getTasks().named("runDatagen", task -> task.getOutputs().dir((Object)outputDirectory));
        }
    }

    private static void extendsFrom(Project project, String name, String extendsFrom) {
        ConfigurationContainer configurations = project.getConfigurations();
        configurations.named(name, configuration -> configuration.extendsFrom(new Configuration[]{configurations.getByName(extendsFrom)}));
    }

    private void dependsOn(SourceSet sourceSet, SourceSet other) {
        sourceSet.setCompileClasspath(sourceSet.getCompileClasspath().plus((FileCollection)other.getOutput()));
        sourceSet.setRuntimeClasspath(sourceSet.getRuntimeClasspath().plus((FileCollection)other.getOutput()));
        FabricApiDataGeneration.extendsFrom(this.getProject(), sourceSet.getCompileClasspathConfigurationName(), other.getCompileClasspathConfigurationName());
        FabricApiDataGeneration.extendsFrom(this.getProject(), sourceSet.getRuntimeClasspathConfigurationName(), other.getRuntimeClasspathConfigurationName());
    }
}

