/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.parchment;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingVisitor;
import org.jetbrains.annotations.Nullable;

public record ParchmentTreeV1(String version, @Nullable List<Class> classes, @Nullable List<Package> packages) {
    public void visit(MappingVisitor visitor, String srcNamespace) throws IOException {
        do {
            if (visitor.visitHeader()) {
                visitor.visitNamespaces(srcNamespace, Collections.emptyList());
            }
            if (!visitor.visitContent() || this.classes() == null) continue;
            for (Class c : this.classes()) {
                c.visit(visitor);
            }
        } while (!visitor.visitEnd());
    }

    public record Class(String name, @Nullable List<Field> fields, @Nullable List<Method> methods, @Nullable List<String> javadoc) {
        public void visit(MappingVisitor visitor) throws IOException {
            if (visitor.visitClass(this.name())) {
                if (!visitor.visitElementContent(MappedElementKind.CLASS)) {
                    return;
                }
                if (this.fields() != null) {
                    for (Field field : this.fields()) {
                        field.visit(visitor);
                    }
                }
                if (this.methods() != null) {
                    for (Method method : this.methods()) {
                        method.visit(visitor);
                    }
                }
                if (this.javadoc() != null) {
                    visitor.visitComment(MappedElementKind.CLASS, String.join((CharSequence)"\n", this.javadoc()));
                }
            }
        }
    }

    public record Package(String name, List<String> javadoc) {
    }

    public record Parameter(int index, String name, @Nullable String javadoc) {
        public void visit(MappingVisitor visitor) throws IOException {
            if (visitor.visitMethodArg(this.index, this.index, this.name)) {
                if (!visitor.visitElementContent(MappedElementKind.METHOD_ARG)) {
                    return;
                }
                if (this.javadoc() != null) {
                    visitor.visitComment(MappedElementKind.METHOD_ARG, this.javadoc);
                }
            }
        }
    }

    public record Method(String name, String descriptor, @Nullable List<Parameter> parameters, @Nullable List<String> javadoc) {
        public void visit(MappingVisitor visitor) throws IOException {
            if (visitor.visitMethod(this.name, this.descriptor)) {
                if (!visitor.visitElementContent(MappedElementKind.METHOD)) {
                    return;
                }
                if (this.parameters() != null) {
                    for (Parameter parameter : this.parameters()) {
                        parameter.visit(visitor);
                    }
                }
                if (this.javadoc() != null) {
                    visitor.visitComment(MappedElementKind.METHOD, String.join((CharSequence)"\n", this.javadoc()));
                }
            }
        }
    }

    public record Field(String name, String descriptor, @Nullable List<String> javadoc) {
        public void visit(MappingVisitor visitor) throws IOException {
            if (visitor.visitField(this.name, this.descriptor)) {
                if (!visitor.visitElementContent(MappedElementKind.FIELD)) {
                    return;
                }
                if (this.javadoc() != null) {
                    visitor.visitComment(MappedElementKind.FIELD, String.join((CharSequence)"\n", this.javadoc()));
                }
            }
        }
    }
}

