/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.extras.annotations;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.TypeAnnotationNode;

class TypeAnnotationNodeSerializer
implements JsonSerializer<TypeAnnotationNode>,
JsonDeserializer<TypeAnnotationNode> {
    TypeAnnotationNodeSerializer() {
    }

    public TypeAnnotationNode deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        AnnotationNode annotation = (AnnotationNode)context.deserialize(json, AnnotationNode.class);
        JsonObject jsonObject = json.getAsJsonObject();
        int typeRef = jsonObject.getAsJsonPrimitive("type_ref").getAsInt();
        String typePath = jsonObject.getAsJsonPrimitive("type_path").getAsString();
        TypeAnnotationNode typeAnnotation = new TypeAnnotationNode(typeRef, TypePath.fromString((String)typePath), annotation.desc);
        annotation.accept((AnnotationVisitor)typeAnnotation);
        return typeAnnotation;
    }

    public JsonElement serialize(TypeAnnotationNode src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = context.serialize((Object)src, AnnotationNode.class).getAsJsonObject();
        json.addProperty("type_ref", (Number)src.typeRef);
        json.addProperty("type_path", src.typePath.toString());
        return json;
    }
}

