/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.extras.annotations;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.AnnotationsData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.TypeAnnotationKey;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrRemapper;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.TypeAnnotationNode;

public record GenericAnnotationData(@SerializedName(value="remove") Set<String> annotationsToRemove, @SerializedName(value="add") List<AnnotationNode> annotationsToAdd, @SerializedName(value="type_remove") Set<TypeAnnotationKey> typeAnnotationsToRemove, @SerializedName(value="type_add") List<TypeAnnotationNode> typeAnnotationsToAdd) {
    public GenericAnnotationData {
        if (annotationsToRemove == null) {
            annotationsToRemove = new LinkedHashSet<String>();
        }
        if (annotationsToAdd == null) {
            annotationsToAdd = new ArrayList<AnnotationNode>();
        }
        if (typeAnnotationsToRemove == null) {
            typeAnnotationsToRemove = new LinkedHashSet<TypeAnnotationKey>();
        }
        if (typeAnnotationsToAdd == null) {
            typeAnnotationsToAdd = new ArrayList<TypeAnnotationNode>();
        }
    }

    GenericAnnotationData merge(GenericAnnotationData other) {
        LinkedHashSet<String> newAnnotationToRemove = new LinkedHashSet<String>(this.annotationsToRemove);
        newAnnotationToRemove.addAll(other.annotationsToRemove);
        ArrayList<AnnotationNode> newAnnotationsToAdd = new ArrayList<AnnotationNode>(this.annotationsToAdd);
        newAnnotationsToAdd.addAll(other.annotationsToAdd);
        LinkedHashSet<TypeAnnotationKey> newTypeAnnotationsToRemove = new LinkedHashSet<TypeAnnotationKey>(this.typeAnnotationsToRemove);
        newTypeAnnotationsToRemove.addAll(other.typeAnnotationsToRemove);
        ArrayList<TypeAnnotationNode> newTypeAnnotationsToAdd = new ArrayList<TypeAnnotationNode>(this.typeAnnotationsToAdd);
        newTypeAnnotationsToAdd.addAll(other.typeAnnotationsToAdd);
        return new GenericAnnotationData(newAnnotationToRemove, newAnnotationsToAdd, newTypeAnnotationsToRemove, newTypeAnnotationsToAdd);
    }

    GenericAnnotationData remap(TinyRemapper remapper) {
        return new GenericAnnotationData(this.annotationsToRemove.stream().map(arg_0 -> ((TrRemapper)remapper.getEnvironment().getRemapper()).map(arg_0)).collect(Collectors.toCollection(LinkedHashSet::new)), this.annotationsToAdd.stream().map(ann -> AnnotationsData.remap(ann, remapper)).collect(Collectors.toCollection(ArrayList::new)), this.typeAnnotationsToRemove.stream().map(key -> key.remap(remapper)).collect(Collectors.toCollection(LinkedHashSet::new)), this.typeAnnotationsToAdd.stream().map(ann -> AnnotationsData.remap(ann, remapper)).collect(Collectors.toCollection(ArrayList::new)));
    }

    public int modifyAccessFlags(int access) {
        if (this.annotationsToRemove.contains("java/lang/Deprecated")) {
            access &= 0xFFFDFFFF;
        }
        if (this.annotationsToAdd.stream().anyMatch(ann -> "Ljava/lang/Deprecated;".equals(ann.desc))) {
            access |= 0x20000;
        }
        return access;
    }
}

