/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.api.processor.SpecContext;
import net.fabricmc.loom.configuration.processors.SpecContextProjectView;
import net.fabricmc.loom.util.AsyncCache;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import net.fabricmc.loom.util.fmj.FabricModJsonHelpers;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public record SpecContextImpl(List<FabricModJson> modDependencies, List<FabricModJson> localMods, List<ModHolder> compileRuntimeMods) implements SpecContext
{
    public static SpecContextImpl create(Project project) {
        return SpecContextImpl.create(new SpecContextProjectView.Impl(project, LoomGradleExtension.get(project)));
    }

    @VisibleForTesting
    public static SpecContextImpl create(SpecContextProjectView projectView) {
        AsyncCache<List<FabricModJson>> fmjCache = new AsyncCache<List<FabricModJson>>();
        return new SpecContextImpl(SpecContextImpl.getDependentMods(projectView, fmjCache), projectView.getMods(), SpecContextImpl.getCompileRuntimeMods(projectView, fmjCache));
    }

    private static List<FabricModJson> getDependentMods(SpecContextProjectView projectView, AsyncCache<List<FabricModJson>> fmjCache) {
        ArrayList futures = new ArrayList();
        for (RemapConfigurationSettings entry : projectView.extension().getRemapConfigurations()) {
            Set artifacts = ((Configuration)entry.getSourceConfiguration().get()).resolve();
            for (File artifact : artifacts) {
                futures.add(fmjCache.get(artifact.toPath().toAbsolutePath().toString(), () -> FabricModJsonFactory.createFromZipOptional(artifact.toPath()).map(List::of).orElseGet(List::of)));
            }
        }
        if (!projectView.disableProjectDependantMods()) {
            for (Project dependentProject : SpecContextImpl.getDependentProjects(projectView).toList()) {
                futures.add(fmjCache.get(dependentProject.getPath(), () -> FabricModJsonHelpers.getModsInProject(dependentProject)));
            }
        }
        return SpecContextImpl.sorted(AsyncCache.joinList(futures));
    }

    private static Stream<Project> getDependentProjects(SpecContextProjectView projectView) {
        Stream<Project> runtimeProjects = projectView.getLoomProjectDependencies("runtimeClasspath");
        Stream<Project> compileProjects = projectView.getLoomProjectDependencies("compileClasspath");
        return Stream.concat(runtimeProjects, compileProjects).distinct();
    }

    private static List<ModHolder> getCompileRuntimeMods(SpecContextProjectView projectView, AsyncCache<List<FabricModJson>> fmjCache) {
        ArrayList<ModHolder> mods = new ArrayList<ModHolder>(SpecContextImpl.getCompileRuntimeModsFromRemapConfigs(projectView, fmjCache));
        for (Project dependentProject : SpecContextImpl.getCompileRuntimeProjectDependencies(projectView).toList()) {
            List projectMods = fmjCache.getBlocking(dependentProject.getPath(), () -> FabricModJsonHelpers.getModsInProject(dependentProject));
            for (FabricModJson mod : projectMods) {
                mods.add(new ModHolder(mod));
            }
        }
        return Collections.unmodifiableList(mods);
    }

    private static List<ModHolder> getCompileRuntimeModsFromRemapConfigs(SpecContextProjectView projectView, AsyncCache<List<FabricModJson>> fmjCache) {
        Set<String> runtimeModIds = SpecContextImpl.getModIds(projectView, fmjCache, projectView.extension().getRuntimeRemapConfigurations().stream().filter(settings -> (Boolean)settings.getApplyDependencyTransforms().get()));
        Set<String> commonRuntimeModIds = projectView.extension().areEnvironmentSourceSetsSplit() ? SpecContextImpl.getModIds(projectView, fmjCache, projectView.extension().getRuntimeRemapConfigurations().stream().filter(settings -> (Boolean)settings.getSourceSet().map(sourceSet -> !sourceSet.getName().equals("client")).get()).filter(settings -> (Boolean)settings.getApplyDependencyTransforms().get())) : null;
        Stream<FabricModJson> compileMods = SpecContextImpl.getMods(projectView, fmjCache, projectView.extension().getCompileRemapConfigurations().stream().filter(settings -> (Boolean)settings.getApplyDependencyTransforms().get()));
        return compileMods.filter(fabricModJson -> runtimeModIds.contains(fabricModJson.getId())).sorted(Comparator.comparing(FabricModJson::getId)).map(fabricModJson -> new ModHolder((FabricModJson)fabricModJson, commonRuntimeModIds == null || commonRuntimeModIds.contains(fabricModJson.getId()))).toList();
    }

    private static Stream<FabricModJson> getMods(SpecContextProjectView projectView, AsyncCache<List<FabricModJson>> fmjCache, Stream<RemapConfigurationSettings> stream) {
        return stream.flatMap(projectView.resolveArtifacts(true)).map(SpecContextImpl.modFromZip(fmjCache)).filter(Objects::nonNull);
    }

    private static Set<String> getModIds(SpecContextProjectView projectView, AsyncCache<List<FabricModJson>> fmjCache, Stream<RemapConfigurationSettings> stream) {
        return SpecContextImpl.getMods(projectView, fmjCache, stream).map(FabricModJson::getId).collect(Collectors.toSet());
    }

    private static Function<Path, @Nullable FabricModJson> modFromZip(AsyncCache<List<FabricModJson>> fmjCache) {
        return zipPath -> {
            List list = fmjCache.getBlocking(zipPath.toAbsolutePath().toString(), () -> FabricModJsonFactory.createFromZipOptional(zipPath).map(List::of).orElseGet(List::of));
            return list.isEmpty() ? null : (FabricModJson)list.getFirst();
        };
    }

    private static Stream<Project> getCompileRuntimeProjectDependencies(SpecContextProjectView projectView) {
        if (projectView.disableProjectDependantMods()) {
            return Stream.empty();
        }
        Stream<Project> runtimeProjects = projectView.getLoomProjectDependencies("runtimeClasspath");
        List<Project> compileProjects = projectView.getLoomProjectDependencies("compileClasspath").toList();
        return runtimeProjects.filter(compileProjects::contains);
    }

    private static List<FabricModJson> sorted(List<FabricModJson> mods) {
        return mods.stream().sorted(Comparator.comparing(FabricModJson::getId)).toList();
    }

    @Override
    public List<FabricModJson> modDependenciesCompileRuntime() {
        return this.compileRuntimeMods.stream().map(ModHolder::mod).toList();
    }

    @Override
    public List<FabricModJson> modDependenciesCompileRuntimeClient() {
        return this.compileRuntimeMods.stream().filter(modHolder -> !modHolder.common()).map(ModHolder::mod).toList();
    }

    private record ModHolder(FabricModJson mod, boolean common) {
        ModHolder(FabricModJson mod) {
            this(mod, true);
        }
    }
}

