/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.gradle;

import java.io.Closeable;
import java.io.IOException;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;

public class ProgressGroup
implements Closeable {
    private final String name;
    private final ProgressLoggerFactory progressLoggerFactory;
    private ProgressLogger progressGroup;

    public ProgressGroup(Project project, String name) {
        this.name = name;
        this.progressLoggerFactory = (ProgressLoggerFactory)((ProjectInternal)project).getServices().get(ProgressLoggerFactory.class);
    }

    public ProgressGroup(String name, ProgressLoggerFactory progressLoggerFactory) {
        this.name = name;
        this.progressLoggerFactory = progressLoggerFactory;
    }

    private void start() {
        this.progressGroup = this.progressLoggerFactory.newOperation(this.name).setDescription(this.name);
        this.progressGroup.started();
    }

    public ProgressLogger createProgressLogger(String name) {
        if (this.progressGroup == null) {
            this.start();
        }
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(this.getClass(), this.progressGroup);
        progressLogger.setDescription(name);
        progressLogger.start(name, null);
        return progressLogger;
    }

    @Override
    public void close() throws IOException {
        if (this.progressGroup != null) {
            this.progressGroup.completed();
            this.progressGroup = null;
        }
    }
}

