/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.prod;

import java.io.File;
import java.io.IOException;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.fabricmc.loom.task.prod.AbstractProductionRunTask;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.loom.util.ZipUtils;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public abstract non-sealed class ServerProductionRunTask
extends AbstractProductionRunTask {
    @Input
    public abstract Property<String> getLoaderVersion();

    @Input
    public abstract Property<String> getMinecraftVersion();

    @Input
    public abstract Property<String> getInstallerVersion();

    @OutputFile
    @ApiStatus.Internal
    public abstract RegularFileProperty getInstallPropertiesJar();

    @Inject
    public ServerProductionRunTask() {
        this.getLoaderVersion().convention(this.getProjectLoaderVersion());
        this.getMinecraftVersion().convention(this.getExtension().getMinecraftVersion());
        this.getInstallPropertiesJar().convention(this.getProject().getLayout().getBuildDirectory().file("server_properties.jar"));
        this.getInstallerVersion().convention((Object)LoomVersions.FABRIC_INSTALLER.version());
        this.getMainClass().convention((Object)"net.fabricmc.installer.ServerLauncher");
        this.getClasspath().from(new Object[]{this.detachedConfigurationProvider("net.fabricmc:fabric-installer:%s:server", (Provider<String>)this.getInstallerVersion())});
        this.getProgramArgs().add((Object)"nogui");
    }

    @Override
    public void run() throws IOException {
        ZipUtils.add(((RegularFile)this.getInstallPropertiesJar().get()).getAsFile().toPath(), "install.properties", "fabric-loader-version=%s\ngame-version=%s".formatted(this.getLoaderVersion().get(), this.getMinecraftVersion().get()));
        super.run();
    }

    @Override
    protected Stream<File> streamClasspath() {
        return Stream.concat(super.streamClasspath(), Stream.of(((RegularFile)this.getInstallPropertiesJar().get()).getAsFile()));
    }
}

