/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;

public class RiffChunk
implements AutoCloseable {
    private final long position;
    private final FileChannel fileChannel;

    public RiffChunk(String id, FileChannel fileChannel) throws IOException {
        if (id.length() != 4) {
            throw new IllegalArgumentException("ID must be 4 characters long");
        }
        fileChannel.write(ByteBuffer.wrap(id.getBytes(StandardCharsets.US_ASCII)));
        this.position = fileChannel.position();
        fileChannel.write(ByteBuffer.allocate(4));
        this.fileChannel = fileChannel;
    }

    @Override
    public void close() throws IOException {
        long endPosition = this.fileChannel.position();
        long chunkSize = endPosition - this.position - 4L;
        if (chunkSize > Integer.MAX_VALUE) {
            throw new IOException("Chunk size is too large");
        }
        this.fileChannel.position(this.position);
        this.fileChannel.write(ByteBuffer.allocate(4).putInt((int)chunkSize).flip());
        this.fileChannel.position(endPosition);
    }
}

