/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.verify;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.providers.minecraft.verify.CertificateChain;
import net.fabricmc.loom.configuration.providers.minecraft.verify.SignatureVerificationFailure;
import net.fabricmc.loom.util.download.DownloadException;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record CertificateRevocationList(Collection<X509CRL> crls, boolean downloadFailure) {
    public static final List<String> CSC3_2010 = List.of("http://crl.verisign.com/pca3-g5.crl", "http://crl.verisign.com/pca3.crl", "http://csc3-2010-crl.verisign.com/CSC3-2010.crl");
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateRevocationList.class);

    public static CertificateRevocationList create(Project project, List<String> urls) throws IOException {
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        boolean downloadFailure = false;
        for (String url : urls) {
            try {
                crls.add(CertificateRevocationList.download(project, url));
            }
            catch (DownloadException e) {
                LOGGER.info("Failed to download CRL from {}: {}", (Object)url, (Object)e.getMessage());
                LOGGER.info("Loom will not be able to verify the integrity of the minecraft jar signature");
                downloadFailure = true;
            }
        }
        return new CertificateRevocationList(crls, downloadFailure);
    }

    static X509CRL download(Project project, String url) throws IOException {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        String name = url.substring(url.lastIndexOf(47) + 1);
        Path path = extension.getFiles().getUserCache().toPath().resolve("crl").resolve(name);
        LOGGER.info("Downloading CRL from {} to {}", (Object)url, (Object)path);
        extension.download(url).allowInsecureProtocol().maxAge(Duration.ofDays(7L)).downloadPath(path);
        return CertificateRevocationList.parse(path);
    }

    static X509CRL parse(Path path) throws IOException {
        X509CRL x509CRL;
        block8: {
            InputStream inStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                x509CRL = (X509CRL)cf.generateCRL(inStream);
                if (inStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CRLException | CertificateException e) {
                    throw new RuntimeException(e);
                }
            }
            inStream.close();
        }
        return x509CRL;
    }

    public void verify(CertificateChain certificateChain) throws SignatureVerificationFailure {
        CertificateChain.visitAll(certificateChain, this::verify);
    }

    private void verify(X509Certificate certificate) throws SignatureVerificationFailure {
        for (X509CRL crl : this.crls) {
            if (!crl.isRevoked(certificate)) continue;
            throw new SignatureVerificationFailure("Certificate " + certificate.getSubjectX500Principal().getName() + " is revoked");
        }
    }
}

