/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.decompile;

import java.util.List;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.decompile.DecompileConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.task.GenerateSourcesTask;
import org.gradle.api.Project;

public class SingleJarDecompileConfiguration
extends DecompileConfiguration<MappedMinecraftProvider> {
    public SingleJarDecompileConfiguration(Project project, MappedMinecraftProvider minecraftProvider) {
        super(project, minecraftProvider);
    }

    @Override
    public String getTaskName(MinecraftJar.Type type) {
        return "genSources";
    }

    @Override
    public final void afterEvaluation() {
        List<MinecraftJar> minecraftJars = this.minecraftProvider.getMinecraftJars();
        assert (minecraftJars.size() == 1);
        MinecraftJar minecraftJar = minecraftJars.get(0);
        String taskBaseName = this.getTaskName(minecraftJar.getType());
        LoomGradleExtension.get(this.project).getDecompilerOptions().forEach(options -> {
            String decompilerName = options.getFormattedName();
            String taskName = "%sWith%s".formatted(taskBaseName, decompilerName);
            this.project.getTasks().register(taskName, GenerateSourcesTask.class, new Object[]{options}).configure(task -> {
                task.getInputJarName().set((Object)minecraftJar.getName());
                task.getSourcesOutputJar().fileValue(GenerateSourcesTask.getJarFileWithSuffix("-sources.jar", minecraftJar.getPath()));
                task.dependsOn(new Object[]{this.project.getTasks().named("validateAccessWidener")});
                task.setDescription("Decompile minecraft using %s.".formatted(decompilerName));
                task.setGroup("fabric");
            });
        });
        this.project.getTasks().register(taskBaseName, task -> {
            task.setDescription("Decompile minecraft using the default decompiler.");
            task.setGroup("fabric");
            task.dependsOn(new Object[]{this.project.getTasks().named("genSourcesWithVineflower")});
        });
    }
}

