/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.AnnotationsData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.ClassAnnotationData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.GenericAnnotationData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.MethodAnnotationData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.TypeAnnotationKey;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrClass;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.RecordComponentVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.TypeAnnotationNode;

public record AnnotationsApplyVisitor(AnnotationsData annotationsData) implements TinyRemapper.ApplyVisitorProvider
{
    public ClassVisitor insertApplyVisitor(TrClass cls, ClassVisitor next) {
        ClassAnnotationData classData = this.annotationsData.classes().get(cls.getName());
        if (classData == null) {
            return next;
        }
        return new AnnotationsApplyClassVisitor(next, classData);
    }

    public static class AnnotationsApplyClassVisitor
    extends ClassVisitor {
        private final ClassAnnotationData classData;
        private boolean hasAddedAnnotations;

        public AnnotationsApplyClassVisitor(ClassVisitor cv, ClassAnnotationData classData) {
            super(589824, cv);
            this.classData = classData;
            this.hasAddedAnnotations = false;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            access = this.classData.modifyAccessFlags(access);
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            if (this.classData.typeAnnotationsToRemove().contains(new TypeAnnotationKey(typeRef, typePath.toString(), Type.getType((String)descriptor).getInternalName()))) {
                return null;
            }
            return super.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (this.classData.annotationsToRemove().contains(Type.getType((String)descriptor).getInternalName())) {
                return null;
            }
            return super.visitAnnotation(descriptor, visible);
        }

        public void visitNestMember(String nestMember) {
            this.addClassAnnotations();
            super.visitNestMember(nestMember);
        }

        public void visitPermittedSubclass(String permittedSubclass) {
            this.addClassAnnotations();
            super.visitPermittedSubclass(permittedSubclass);
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            this.addClassAnnotations();
            super.visitInnerClass(name, outerName, innerName, access);
        }

        public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
            this.addClassAnnotations();
            RecordComponentVisitor rcv = super.visitRecordComponent(name, descriptor, signature);
            if (rcv == null) {
                return null;
            }
            final GenericAnnotationData fieldData = this.classData.getFieldData(name, descriptor);
            if (fieldData == null) {
                return rcv;
            }
            return new RecordComponentVisitor(this, 589824, rcv){

                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    if (fieldData.annotationsToRemove().contains(Type.getType((String)descriptor).getInternalName())) {
                        return null;
                    }
                    return super.visitAnnotation(descriptor, visible);
                }

                public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
                    if (fieldData.typeAnnotationsToRemove().contains(new TypeAnnotationKey(typeRef, typePath.toString(), Type.getType((String)descriptor).getInternalName()))) {
                        return null;
                    }
                    return super.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
                }

                public void visitEnd() {
                    AnnotationVisitor av;
                    for (AnnotationNode annotation : fieldData.annotationsToAdd()) {
                        av = this.delegate.visitAnnotation(annotation.desc, false);
                        if (av == null) continue;
                        annotation.accept(av);
                    }
                    for (TypeAnnotationNode typeAnnotation : fieldData.typeAnnotationsToAdd()) {
                        av = this.delegate.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, false);
                        if (av == null) continue;
                        typeAnnotation.accept(av);
                    }
                    super.visitEnd();
                }
            };
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            this.addClassAnnotations();
            final GenericAnnotationData fieldData = this.classData.getFieldData(name, descriptor);
            if (fieldData == null) {
                return super.visitField(access, name, descriptor, signature, value);
            }
            FieldVisitor fv = super.visitField(fieldData.modifyAccessFlags(access), name, descriptor, signature, value);
            if (fv == null) {
                return null;
            }
            return new FieldVisitor(this, 589824, fv){

                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    if (fieldData.annotationsToRemove().contains(Type.getType((String)descriptor).getInternalName())) {
                        return null;
                    }
                    return super.visitAnnotation(descriptor, visible);
                }

                public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
                    if (fieldData.typeAnnotationsToRemove().contains(new TypeAnnotationKey(typeRef, typePath.toString(), Type.getType((String)descriptor).getInternalName()))) {
                        return null;
                    }
                    return super.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
                }

                public void visitEnd() {
                    AnnotationVisitor av;
                    for (AnnotationNode annotation : fieldData.annotationsToAdd()) {
                        av = this.fv.visitAnnotation(annotation.desc, false);
                        if (av == null) continue;
                        annotation.accept(av);
                    }
                    for (TypeAnnotationNode typeAnnotation : fieldData.typeAnnotationsToAdd()) {
                        av = this.fv.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, false);
                        if (av == null) continue;
                        typeAnnotation.accept(av);
                    }
                    super.visitEnd();
                }
            };
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            this.addClassAnnotations();
            final MethodAnnotationData methodData = this.classData.getMethodData(name, descriptor);
            if (methodData == null) {
                return super.visitMethod(access, name, descriptor, signature, exceptions);
            }
            MethodVisitor mv = super.visitMethod(methodData.modifyAccessFlags(access), name, descriptor, signature, exceptions);
            if (mv == null) {
                return null;
            }
            return new MethodVisitor(this, 589824, mv){
                boolean hasAddedAnnotations;
                {
                    super(arg0, arg1);
                    this.hasAddedAnnotations = false;
                }

                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    if (methodData.annotationsToRemove().contains(Type.getType((String)descriptor).getInternalName())) {
                        return null;
                    }
                    return super.visitAnnotation(descriptor, visible);
                }

                public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
                    if (methodData.typeAnnotationsToRemove().contains(new TypeAnnotationKey(typeRef, typePath.toString(), Type.getType((String)descriptor).getInternalName()))) {
                        return null;
                    }
                    return super.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
                }

                public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
                    GenericAnnotationData parameterData = methodData.parameters().get(parameter);
                    if (parameterData != null && parameterData.annotationsToRemove().contains(Type.getType((String)descriptor).getInternalName())) {
                        return null;
                    }
                    return super.visitParameterAnnotation(parameter, descriptor, visible);
                }

                public void visitCode() {
                    this.addMethodAnnotations();
                    super.visitCode();
                }

                public void visitEnd() {
                    this.addMethodAnnotations();
                    super.visitEnd();
                }

                void addMethodAnnotations() {
                    AnnotationVisitor av;
                    if (this.hasAddedAnnotations) {
                        return;
                    }
                    this.hasAddedAnnotations = true;
                    for (AnnotationNode annotation : methodData.annotationsToAdd()) {
                        av = this.mv.visitAnnotation(annotation.desc, false);
                        if (av == null) continue;
                        annotation.accept(av);
                    }
                    for (TypeAnnotationNode typeAnnotation : methodData.typeAnnotationsToAdd()) {
                        av = this.mv.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, false);
                        if (av == null) continue;
                        typeAnnotation.accept(av);
                    }
                    methodData.parameters().forEach((paramIndex, paramData) -> {
                        for (AnnotationNode annotation : paramData.annotationsToAdd()) {
                            AnnotationVisitor av = this.mv.visitParameterAnnotation(paramIndex.intValue(), annotation.desc, false);
                            if (av == null) continue;
                            annotation.accept(av);
                        }
                    });
                }
            };
        }

        public void visitEnd() {
            this.addClassAnnotations();
            super.visitEnd();
        }

        private void addClassAnnotations() {
            AnnotationVisitor av;
            if (this.hasAddedAnnotations) {
                return;
            }
            this.hasAddedAnnotations = true;
            for (AnnotationNode annotation : this.classData.annotationsToAdd()) {
                av = this.cv.visitAnnotation(annotation.desc, false);
                if (av == null) continue;
                annotation.accept(av);
            }
            for (TypeAnnotationNode typeAnnotation : this.classData.typeAnnotationsToAdd()) {
                av = this.cv.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, false);
                if (av == null) continue;
                typeAnnotation.accept(av);
            }
        }
    }
}

