/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import java.util.List;
import kotlin.metadata.jvm.KotlinClassMetadata;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.util.ASMifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibraryLocationLogger {
    private static final List<Class<?>> libraryClasses = List.of(KotlinClassMetadata.class, ClassVisitor.class, Analyzer.class, ClassRemapper.class, ClassNode.class, ASMifier.class, Gson.class, Preconditions.class, FileUtils.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(LibraryLocationLogger.class);

    public static void logLibraryVersions() {
        for (Class<?> clazz : libraryClasses) {
            LOGGER.info("({}) with version ({}) was loaded from ({})", new Object[]{clazz.getName(), clazz.getPackage().getImplementationVersion(), clazz.getProtectionDomain().getCodeSource().getLocation().getPath()});
        }
    }

    private LibraryLocationLogger() {
    }
}

