/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.util.RecordComponentFixVisitor;
import net.fabricmc.loom.util.TinyRemapperLoggerAdapter;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrLogger;
import org.gradle.api.Project;

public final class TinyRemapperHelper {
    private static final Map<String, String> JSR_TO_JETBRAINS = new ImmutableMap.Builder().put((Object)"javax/annotation/Nullable", (Object)"org/jetbrains/annotations/Nullable").put((Object)"javax/annotation/Nonnull", (Object)"org/jetbrains/annotations/NotNull").put((Object)"javax/annotation/concurrent/Immutable", (Object)"org/jetbrains/annotations/Unmodifiable").build();
    private static final Pattern MC_LV_PATTERN = Pattern.compile("\\$\\$\\d+");

    private TinyRemapperHelper() {
    }

    public static TinyRemapper getTinyRemapper(Project project, ServiceFactory serviceFactory, String fromM, String toM) throws IOException {
        return TinyRemapperHelper.getTinyRemapper(project, serviceFactory, fromM, toM, false, builder -> {});
    }

    public static TinyRemapper getTinyRemapper(Project project, ServiceFactory serviceFactory, String fromM, String toM, boolean fixRecords, Consumer<TinyRemapper.Builder> builderConsumer) throws IOException {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        MemoryMappingTree mappingTree = extension.getMappingConfiguration().getMappingsService(project, serviceFactory).getMappingTree();
        if (fixRecords && !mappingTree.getSrcNamespace().equals(fromM)) {
            throw new IllegalStateException("Mappings src namespace must match remap src namespace, expected " + fromM + " but got " + mappingTree.getSrcNamespace());
        }
        int intermediaryNsId = mappingTree.getNamespaceId(MappingsNamespace.INTERMEDIARY.toString());
        TinyRemapper.Builder builder = TinyRemapper.newRemapper((TrLogger)TinyRemapperLoggerAdapter.INSTANCE).withMappings(TinyRemapperHelper.create((MappingTree)mappingTree, fromM, toM, true)).withMappings(out -> JSR_TO_JETBRAINS.forEach((arg_0, arg_1) -> ((IMappingProvider.MappingAcceptor)out).acceptClass(arg_0, arg_1))).renameInvalidLocals(true).rebuildSourceFilenames(true).invalidLvNamePattern(MC_LV_PATTERN).inferNameFromSameLvIndex(true).withKnownIndyBsm((Set)extension.getKnownIndyBsms().get()).extraPreApplyVisitor((cls, next) -> {
            if (fixRecords && !cls.isRecord() && "java/lang/Record".equals(cls.getSuperName())) {
                return new RecordComponentFixVisitor(next, mappingTree, intermediaryNsId);
            }
            return next;
        });
        builderConsumer.accept(builder);
        return builder.build();
    }

    private static IMappingProvider.Member memberOf(String className, String memberName, String descriptor) {
        return new IMappingProvider.Member(className, memberName, descriptor);
    }

    public static IMappingProvider create(Path mappings, String from, String to, boolean remapLocalVariables) throws IOException {
        MemoryMappingTree mappingTree = new MemoryMappingTree();
        MappingReader.read((Path)mappings, (MappingVisitor)mappingTree);
        return TinyRemapperHelper.create((MappingTree)mappingTree, from, to, remapLocalVariables);
    }

    public static IMappingProvider create(MappingTree mappings, String from, String to, boolean remapLocalVariables) {
        return acceptor -> {
            int fromId = mappings.getNamespaceId(from);
            int toId = mappings.getNamespaceId(to);
            for (MappingTree.ClassMapping classDef : mappings.getClasses()) {
                String className = classDef.getName(fromId);
                if (className == null) continue;
                String dstClassName = classDef.getName(toId);
                if (dstClassName == null) {
                    dstClassName = className;
                }
                acceptor.acceptClass(className, dstClassName);
                for (MappingTree.FieldMapping field : classDef.getFields()) {
                    String fieldName = field.getName(fromId);
                    if (fieldName == null) continue;
                    String dstFieldName = field.getName(toId);
                    if (dstFieldName == null) {
                        dstFieldName = fieldName;
                    }
                    acceptor.acceptField(TinyRemapperHelper.memberOf(className, fieldName, field.getDesc(fromId)), dstFieldName);
                }
                for (MappingTree.MethodMapping method : classDef.getMethods()) {
                    String methodName = method.getName(fromId);
                    if (methodName == null) continue;
                    String dstMethodName = method.getName(toId);
                    if (dstMethodName == null) {
                        dstMethodName = methodName;
                    }
                    IMappingProvider.Member methodIdentifier = TinyRemapperHelper.memberOf(className, methodName, method.getDesc(fromId));
                    acceptor.acceptMethod(methodIdentifier, dstMethodName);
                    if (!remapLocalVariables) continue;
                    for (MappingTree.MethodArgMapping parameter : method.getArgs()) {
                        String name = parameter.getName(toId);
                        if (name == null) continue;
                        acceptor.acceptMethodArg(methodIdentifier, parameter.getLvIndex(), name);
                    }
                    for (MappingTree.MethodVarMapping localVariable : method.getVars()) {
                        acceptor.acceptMethodVar(methodIdentifier, localVariable.getLvIndex(), localVariable.getStartOpIdx(), localVariable.getLvtRowIndex(), localVariable.getName(toId));
                    }
                }
            }
        };
    }
}

