/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import com.google.common.base.Suppliers;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.gradle.GradleTypeAdapter;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.tasks.Internal;

public abstract class CacheKey {
    private static final int CHECKSUM_LENGTH = 8;
    private final transient Supplier<String> jsonSupplier = Suppliers.memoize(() -> GradleTypeAdapter.GSON.toJson((Object)this));
    private final transient Supplier<String> cacheKeySupplier = Suppliers.memoize(() -> Checksum.sha1Hex(this.jsonSupplier.get().getBytes(StandardCharsets.UTF_8)).substring(0, 8));

    public static <T> T create(Project project, Class<T> clazz, Action<T> action) {
        Object instance = project.getObjects().newInstance(clazz, new Object[0]);
        action.execute(instance);
        return (T)instance;
    }

    @Internal
    public final String getJson() {
        return this.jsonSupplier.get();
    }

    @Internal
    public final String getCacheKey() {
        return this.cacheKeySupplier.get();
    }
}

