/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.storage;

import java.util.Objects;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;

public interface TransferVariant<O> {
    public boolean isBlank();

    public O getObject();

    public DataComponentPatch getComponents();

    public DataComponentMap getComponentMap();

    default public boolean hasComponents() {
        return !this.getComponents().isEmpty();
    }

    default public boolean componentsMatch(DataComponentPatch other) {
        return Objects.equals(this.getComponents(), other);
    }

    default public boolean isOf(O object) {
        return this.getObject() == object;
    }

    default public TransferVariant<O> withComponentChanges(DataComponentPatch changes) {
        throw new UnsupportedOperationException("withComponentChanges is not supported by this TransferVariant");
    }
}

