/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.mixin.transfer.BundleContentsAccessor;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import org.apache.commons.lang3.math.Fraction;

public class BundleContentsStorage
implements Storage<ItemVariant> {
    private final ContainerItemContext ctx;
    private final List<BundleSlotWrapper> slotCache = new ArrayList<BundleSlotWrapper>();
    private List<StorageView<ItemVariant>> slots = List.of();
    private final Item originalItem;

    public BundleContentsStorage(ContainerItemContext ctx) {
        this.ctx = ctx;
        this.originalItem = ctx.getItemVariant().getItem();
    }

    private boolean updateStack(DataComponentPatch changes, TransactionContext transaction) {
        ItemVariant newVariant = this.ctx.getItemVariant().withComponentChanges(changes);
        return this.ctx.exchange(newVariant, 1L, transaction) > 0L;
    }

    @Override
    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        ItemStack stack;
        StoragePreconditions.notBlankNotNegative(resource, maxAmount);
        if (!this.isStillValid()) {
            return 0L;
        }
        if (maxAmount > Integer.MAX_VALUE) {
            maxAmount = Integer.MAX_VALUE;
        }
        if (!BundleContents.canItemBeInBundle((ItemStack)(stack = resource.toStack((int)maxAmount)))) {
            return 0L;
        }
        BundleContents.Mutable builder = new BundleContents.Mutable(this.bundleContents());
        int inserted = builder.tryInsert(stack);
        if (inserted == 0) {
            return 0L;
        }
        DataComponentPatch changes = DataComponentPatch.builder().set(DataComponents.BUNDLE_CONTENTS, (Object)builder.toImmutable()).build();
        if (!this.updateStack(changes, transaction)) {
            return 0L;
        }
        return inserted;
    }

    @Override
    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative(maxAmount);
        if (!this.isStillValid()) {
            return 0L;
        }
        this.updateSlotsIfNeeded();
        long amount = 0L;
        for (StorageView<ItemVariant> slot : this.slots) {
            if ((amount += slot.extract(resource, maxAmount - amount, transaction)) == maxAmount) break;
        }
        return amount;
    }

    @Override
    public Iterator<StorageView<ItemVariant>> iterator() {
        this.updateSlotsIfNeeded();
        return this.slots.iterator();
    }

    private boolean isStillValid() {
        return this.ctx.getItemVariant().getItem() == this.originalItem;
    }

    private void updateSlotsIfNeeded() {
        int bundleSize = this.bundleContents().size();
        if (this.slots.size() != bundleSize) {
            while (bundleSize > this.slotCache.size()) {
                this.slotCache.add(new BundleSlotWrapper(this.slotCache.size()));
            }
            this.slots = Collections.unmodifiableList(this.slotCache.subList(0, bundleSize));
        }
    }

    BundleContents bundleContents() {
        return (BundleContents)this.ctx.getItemVariant().getComponentMap().getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
    }

    private class BundleSlotWrapper
    implements StorageView<ItemVariant> {
        private final int index;

        private BundleSlotWrapper(int index) {
            this.index = index;
        }

        private ItemStack getStack() {
            if (BundleContentsStorage.this.bundleContents().size() <= this.index) {
                return ItemStack.EMPTY;
            }
            return (ItemStack)((List)BundleContentsStorage.this.bundleContents().items()).get(this.index);
        }

        @Override
        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            DataComponentPatch changes;
            StoragePreconditions.notNegative(maxAmount);
            if (!BundleContentsStorage.this.isStillValid()) {
                return 0L;
            }
            if (BundleContentsStorage.this.bundleContents().size() <= this.index) {
                return 0L;
            }
            if (!resource.matches(this.getStack())) {
                return 0L;
            }
            ArrayList stacksCopy = new ArrayList((Collection)BundleContentsStorage.this.bundleContents().itemsCopy());
            int extracted = (int)Math.min((long)((ItemStack)stacksCopy.get(this.index)).getCount(), maxAmount);
            ((ItemStack)stacksCopy.get(this.index)).shrink(extracted);
            if (((ItemStack)stacksCopy.get(this.index)).isEmpty()) {
                stacksCopy.remove(this.index);
            }
            if (!BundleContentsStorage.this.updateStack(changes = DataComponentPatch.builder().set(DataComponents.BUNDLE_CONTENTS, (Object)new BundleContents(stacksCopy)).build(), transaction)) {
                return 0L;
            }
            return extracted;
        }

        @Override
        public boolean isResourceBlank() {
            return this.getStack().isEmpty();
        }

        @Override
        public ItemVariant getResource() {
            return ItemVariant.of(this.getStack());
        }

        @Override
        public long getAmount() {
            return this.getStack().getCount();
        }

        @Override
        public long getCapacity() {
            Fraction remainingSpace = Fraction.ONE.subtract(BundleContentsStorage.this.bundleContents().weight());
            int extraAllowed = Math.max(remainingSpace.divideBy(BundleContentsAccessor.getOccupancy(this.getStack())).intValue(), 0);
            return this.getAmount() + (long)extraAllowed;
        }
    }
}

