/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.transfer;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import net.fabricmc.fabric.impl.transfer.item.SpecialLogicAccess;
import net.minecraft.class_11596;

@Mixin(class_11596.class)
interface ListInventoryMixin extends class_11596, SpecialLogicAccess {
	@WrapOperation(method = "setStack", at = @At(value = "INVOKE", target = "Lnet/minecraft/inventory/ListInventory;markDirty()V"))
	private void cancelMarkDirty(class_11596 instance, Operation<Void> original) {
		if (!this.fabric_shouldSuppressSpecialLogic()) {
			original.call(instance);
		}
	}
}
