/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.tag;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.fabric.api.resource.v1.reloader.SimpleResourceReloader;
import net.fabricmc.fabric.impl.tag.SimpleRegistryExtension;
import net.fabricmc.fabric.impl.tag.TagAliasEnabledRegistryWrapper;
import net.fabricmc.fabric.impl.tag.TagAliasGroup;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StrictJsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TagAliasLoader
extends SimpleResourceReloader<Map<ResourceKey<? extends Registry<?>>, List<Data>>> {
    public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"fabric-tag-api-v1", (String)"tag_alias_groups");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-tag-api-v1");

    /*
     * Loose catch block
     */
    protected Map<ResourceKey<? extends Registry<?>>, List<Data>> prepare(PreparableReloadListener.SharedState store) {
        HashMap dataByRegistry = new HashMap();
        HolderLookup.Provider registries = (HolderLookup.Provider)store.get(ResourceLoader.RELOADER_REGISTRY_LOOKUP_KEY);
        Iterator registryIterator = registries.listRegistryKeys().iterator();
        while (registryIterator.hasNext()) {
            ResourceKey registryKey = (ResourceKey)registryIterator.next();
            FileToIdConverter resourceFinder = FileToIdConverter.json((String)TagAliasLoader.getDirectory(registryKey));
            for (Map.Entry entry : resourceFinder.listMatchingResources(store.resourceManager()).entrySet()) {
                Identifier resourcePath = (Identifier)entry.getKey();
                Identifier groupId = resourceFinder.fileToId(resourcePath);
                try {
                    BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                    try {
                        DataResult dataResult;
                        JsonElement json = StrictJsonParser.parse((Reader)reader);
                        Codec codec = TagAliasGroup.codec(registryKey);
                        Objects.requireNonNull(codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json));
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult, n)) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case 0: {
                                TagAliasGroup tagAliasGroup;
                                DataResult.Success success = (DataResult.Success)dataResult;
                                TagAliasGroup group = tagAliasGroup = (TagAliasGroup)success.value();
                                TagAliasGroup unused = tagAliasGroup = success.lifecycle();
                                Data data = new Data(groupId, group);
                                dataByRegistry.computeIfAbsent(registryKey, key -> new ArrayList()).add(data);
                                break;
                            }
                            case 1: {
                                DataResult.Error error = (DataResult.Error)dataResult;
                                LOGGER.error("[Fabric] Couldn't parse tag alias group file '{}' from '{}': {}", new Object[]{groupId, resourcePath, error.message()});
                                break;
                            }
                        }
                        continue;
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (JsonParseException | IOException e) {
                    LOGGER.error("[Fabric] Couldn't parse tag alias group file '{}' from '{}'", new Object[]{groupId, resourcePath, e});
                }
            }
        }
        return dataByRegistry;
    }

    private static String getDirectory(ResourceKey<? extends Registry<?>> registryKey) {
        Object directory = "fabric/tag_alias/";
        Identifier registryId = registryKey.identifier();
        if (!"minecraft".equals(registryId.getNamespace())) {
            directory = (String)directory + registryId.getNamespace() + "/";
        }
        return (String)directory + registryId.getPath();
    }

    protected void apply(Map<ResourceKey<? extends Registry<?>>, List<Data>> prepared, PreparableReloadListener.SharedState store) {
        for (Map.Entry<ResourceKey<Registry<?>>, List<Data>> entry : prepared.entrySet()) {
            HashMap groupsByTag = new HashMap();
            for (Data data : entry.getValue()) {
                HashSet group = new HashSet(data.group.tags());
                for (TagKey<?> tag : data.group.tags()) {
                    Set oldGroup = (Set)groupsByTag.get(tag);
                    if (oldGroup != null) {
                        group.addAll(oldGroup);
                        for (TagKey other : oldGroup) {
                            groupsByTag.put(other, group);
                        }
                    }
                    groupsByTag.put(tag, group);
                }
            }
            groupsByTag.values().removeIf(tags -> tags.size() == 1);
            HolderLookup.RegistryLookup wrapper = ((HolderLookup.Provider)store.get(ResourceLoader.RELOADER_REGISTRY_LOOKUP_KEY)).lookupOrThrow(entry.getKey());
            if (wrapper instanceof TagAliasEnabledRegistryWrapper) {
                TagAliasEnabledRegistryWrapper aliasWrapper = (TagAliasEnabledRegistryWrapper)wrapper;
                aliasWrapper.fabric_loadTagAliases(groupsByTag);
                continue;
            }
            throw new ClassCastException("[Fabric] Couldn't apply tag aliases to registry wrapper %s (%s) since it doesn't implement TagAliasEnabledRegistryWrapper".formatted(wrapper, entry.getKey().identifier()));
        }
    }

    public static <T> void applyToDynamicRegistries(LayeredRegistryAccess<T> registries, T phase) {
        Iterator registryEntries = registries.getLayer(phase).registries().iterator();
        while (registryEntries.hasNext()) {
            Registry registry = ((RegistryAccess.RegistryEntry)registryEntries.next()).value();
            if (registry instanceof SimpleRegistryExtension) {
                SimpleRegistryExtension extension = (SimpleRegistryExtension)registry;
                extension.fabric_applyPendingTagAliases();
                extension.fabric_refreshTags();
                continue;
            }
            throw new ClassCastException("[Fabric] Couldn't apply pending tag aliases to registry %s (%s) since it doesn't implement SimpleRegistryExtension".formatted(registry, registry.getClass().getName()));
        }
    }

    protected record Data(Identifier groupId, TagAliasGroup<?> group) {
    }
}

