/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.tag.client;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2378;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class ClientTagsImpl {
	private static final Map<class_6862<?>, ClientTagsLoader.LoadedTag> LOCAL_TAG_HIERARCHY = new ConcurrentHashMap<>();

	public static <T> boolean isInWithLocalFallback(class_6862<T> tagKey, class_6880<T> registryEntry) {
		return isInWithLocalFallback(tagKey, registryEntry, new HashSet<>());
	}

	@SuppressWarnings("unchecked")
	private static <T> boolean isInWithLocalFallback(class_6862<T> tagKey, class_6880<T> registryEntry, Set<class_6862<T>> checked) {
		if (checked.contains(tagKey)) {
			return false;
		}

		checked.add(tagKey);

		// Check if the tag exists in the dynamic registry first
		Optional<? extends class_2378<T>> maybeRegistry = ClientTagsImpl.getRegistry(tagKey);

		if (maybeRegistry.isPresent()) {
			// Check the synced tag exists and use that
			if (maybeRegistry.get().method_46733(tagKey).isPresent()) {
				return registryEntry.method_40220(tagKey);
			}
		}

		if (registryEntry.method_40230().isEmpty()) {
			// No key?
			return false;
		}

		// Recursively search the entries contained with the tag
		ClientTagsLoader.LoadedTag wt = ClientTagsImpl.getOrCreatePartiallySyncedTag(tagKey);

		if (wt.immediateChildIds().contains(registryEntry.method_40230().get().method_29177())) {
			return true;
		}

		for (class_6862<?> key : wt.immediateChildTags()) {
			if (isInWithLocalFallback((class_6862<T>) key, registryEntry, checked)) {
				return true;
			}

			checked.add((class_6862<T>) key);
		}

		return false;
	}

	@SuppressWarnings("unchecked")
	public static <T> Optional<? extends class_2378<T>> getRegistry(class_6862<T> tagKey) {
		Objects.requireNonNull(tagKey);

		// Check if the tag represents a dynamic registry
		if (class_310.method_1551() != null) {
			if (class_310.method_1551().field_1687 != null) {
				if (class_310.method_1551().field_1687.method_30349() != null) {
					Optional<? extends class_2378<T>> maybeRegistry = class_310.method_1551().field_1687
							.method_30349().method_46759(tagKey.comp_326());
					if (maybeRegistry.isPresent()) return maybeRegistry;
				}
			}
		}

		return (Optional<? extends class_2378<T>>) class_7923.field_41167.method_17966(tagKey.comp_326().method_29177());
	}

	@SuppressWarnings("unchecked")
	public static <T> Optional<class_6880<T>> getRegistryEntry(class_6862<T> tagKey, T entry) {
		Optional<? extends class_2378<?>> maybeRegistry = getRegistry(tagKey);

		if (maybeRegistry.isEmpty() || !tagKey.method_41007(maybeRegistry.get().method_46765())) {
			return Optional.empty();
		}

		class_2378<T> registry = (class_2378<T>) maybeRegistry.get();

		Optional<class_5321<T>> maybeKey = registry.method_29113(entry);

		return maybeKey.map(registry::method_46747);
	}

	public static ClientTagsLoader.LoadedTag getOrCreatePartiallySyncedTag(class_6862<?> tagKey) {
		ClientTagsLoader.LoadedTag loadedTag = LOCAL_TAG_HIERARCHY.get(tagKey);

		if (loadedTag == null) {
			loadedTag = ClientTagsLoader.loadTag(tagKey);
			LOCAL_TAG_HIERARCHY.put(tagKey, loadedTag);
		}

		return loadedTag;
	}
}
