/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.screen.v1;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.impl.client.screen.ScreenExtensions;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public final class ScreenEvents {
    public static final Event<BeforeInit> BEFORE_INIT = EventFactory.createArrayBacked(BeforeInit.class, callbacks -> (client, screen, scaledWidth, scaledHeight) -> {
        for (BeforeInit callback : callbacks) {
            callback.beforeInit(client, screen, scaledWidth, scaledHeight);
        }
    });
    public static final Event<AfterInit> AFTER_INIT = EventFactory.createArrayBacked(AfterInit.class, callbacks -> (client, screen, scaledWidth, scaledHeight) -> {
        for (AfterInit callback : callbacks) {
            callback.afterInit(client, screen, scaledWidth, scaledHeight);
        }
    });

    public static Event<Remove> remove(class_437 screen) {
        Objects.requireNonNull(screen, "Screen cannot be null");
        return ScreenExtensions.getExtensions(screen).fabric_getRemoveEvent();
    }

    public static Event<BeforeRender> beforeRender(class_437 screen) {
        Objects.requireNonNull(screen, "Screen cannot be null");
        return ScreenExtensions.getExtensions(screen).fabric_getBeforeRenderEvent();
    }

    public static Event<AfterRender> afterRender(class_437 screen) {
        Objects.requireNonNull(screen, "Screen cannot be null");
        return ScreenExtensions.getExtensions(screen).fabric_getAfterRenderEvent();
    }

    public static Event<BeforeTick> beforeTick(class_437 screen) {
        Objects.requireNonNull(screen, "Screen cannot be null");
        return ScreenExtensions.getExtensions(screen).fabric_getBeforeTickEvent();
    }

    public static Event<AfterTick> afterTick(class_437 screen) {
        Objects.requireNonNull(screen, "Screen cannot be null");
        return ScreenExtensions.getExtensions(screen).fabric_getAfterTickEvent();
    }

    private ScreenEvents() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AfterInit {
        public void afterInit(class_310 var1, class_437 var2, int var3, int var4);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface BeforeInit {
        public void beforeInit(class_310 var1, class_437 var2, int var3, int var4);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AfterTick {
        public void afterTick(class_437 var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface BeforeTick {
        public void beforeTick(class_437 var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AfterRender {
        public void afterRender(class_437 var1, class_332 var2, int var3, int var4, float var5);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface BeforeRender {
        public void beforeRender(class_437 var1, class_332 var2, int var3, int var4, float var5);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface Remove {
        public void onRemove(class_437 var1);
    }
}

