/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.resource.client;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;

public record PackTooltipComponent(Optional<class_2561> name, Optional<List<class_5481>> description)
		implements class_5632, class_5684 {
	@Override
	public int method_32661(class_327 font) {
		int height = 0;

		if (this.name.isPresent()) {
			height += font.field_2000 + 2;
		}

		if (this.description.isPresent()) {
			height += this.description.get().size() * font.field_2000 + 3;
		}

		if (this.name.isPresent() && this.description.isPresent()) {
			height += font.field_2000;
		}

		return height;
	}

	@Override
	public int method_32664(class_327 font) {
		return Math.max(
				this.name.map(font::method_27525).orElse(0),
				this.description
						.map(description -> description.stream().mapToInt(font::method_30880).max().orElse(0))
						.orElse(0)
		);
	}

	@Override
	public void method_32665(class_332 graphics, class_327 font, int x, int y) {
		if (this.name.isPresent()) {
			graphics.method_51439(font, this.name.get(), x, y, 0xffffffff, true);
			y += font.field_2000 + 1;

			if (this.description.isPresent()) {
				y += font.field_2000;
			}
		}

		if (this.description.isPresent()) {
			for (class_5481 line : this.description.get()) {
				graphics.method_51430(font, line, x, y, 0xffffffff, true);
				y += font.field_2000 + 1;
			}
		}
	}

	@Override
	public void method_32666(class_327 font, int x, int y, int width, int height, class_332 graphics) {
		if (this.name.isPresent() && this.description.isPresent()) {
			graphics.method_25294(
					x, y + font.field_2000 + 4,
					x + this.method_32664(font), y + font.field_2000 + 5,
					0xff000000 | class_124.field_1080.method_532()
			);
		}
	}
}
