/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.fabric.impl.resource.loader.BuiltinModResourcePackSource;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.Tuple;

public class ResourceManagerHelperImpl
implements ResourceManagerHelper {
    private static final Map<PackType, ResourceManagerHelperImpl> registryMap = new HashMap<PackType, ResourceManagerHelperImpl>();
    private static final Set<Tuple<Component, ModNioResourcePack>> builtinResourcePacks = new HashSet<Tuple<Component, ModNioResourcePack>>();
    private final ResourceLoader resourceLoader;

    private ResourceManagerHelperImpl(PackType type) {
        this.resourceLoader = ResourceLoader.get((PackType)type);
    }

    public static ResourceManagerHelperImpl get(PackType type) {
        return registryMap.computeIfAbsent(type, ResourceManagerHelperImpl::new);
    }

    public static boolean registerBuiltinResourcePack(Identifier id, String subPath, ModContainer container, Component displayName, ResourcePackActivationType activationType) {
        List paths = container.getRootPaths();
        String separator = ((Path)paths.getFirst()).getFileSystem().getSeparator();
        subPath = subPath.replace("/", separator);
        ModNioResourcePack resourcePack = ModNioResourcePack.create(id.toString(), container, subPath, PackType.CLIENT_RESOURCES, activationType, false);
        ModNioResourcePack dataPack = ModNioResourcePack.create(id.toString(), container, subPath, PackType.SERVER_DATA, activationType, false);
        if (resourcePack == null && dataPack == null) {
            return false;
        }
        if (resourcePack != null) {
            builtinResourcePacks.add((Tuple<Component, ModNioResourcePack>)new Tuple((Object)displayName, (Object)resourcePack));
        }
        if (dataPack != null) {
            builtinResourcePacks.add((Tuple<Component, ModNioResourcePack>)new Tuple((Object)displayName, (Object)dataPack));
        }
        return true;
    }

    public static boolean registerBuiltinResourcePack(Identifier id, String subPath, ModContainer container, ResourcePackActivationType activationType) {
        return ResourceManagerHelperImpl.registerBuiltinResourcePack(id, subPath, container, (Component)Component.literal((String)(id.getNamespace() + "/" + id.getPath())), activationType);
    }

    public static void registerBuiltinResourcePacks(PackType resourceType, Consumer<Pack> consumer) {
        for (final Tuple<Component, ModNioResourcePack> entry : builtinResourcePacks) {
            ModNioResourcePack pack = (ModNioResourcePack)entry.getB();
            if (pack.getNamespaces(resourceType).isEmpty()) continue;
            PackLocationInfo info = new PackLocationInfo(((ModNioResourcePack)entry.getB()).packId(), (Component)entry.getA(), (PackSource)new BuiltinModResourcePackSource(pack.getFabricModMetadata().getName()), ((ModNioResourcePack)entry.getB()).knownPackInfo());
            PackSelectionConfig info2 = new PackSelectionConfig(pack.getActivationType() == ResourcePackActivationType.ALWAYS_ENABLED, Pack.Position.TOP, false);
            Pack profile = Pack.readMetaAndCreate((PackLocationInfo)info, (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

                public PackResources openPrimary(PackLocationInfo var1) {
                    return (PackResources)entry.getB();
                }

                public PackResources openFull(PackLocationInfo var1, Pack.Metadata metadata) {
                    ModNioResourcePack pack = (ModNioResourcePack)entry.getB();
                    if (metadata.overlays().isEmpty()) {
                        return pack;
                    }
                    ArrayList<ModNioResourcePack> overlays = new ArrayList<ModNioResourcePack>(metadata.overlays().size());
                    for (String overlay : metadata.overlays()) {
                        overlays.add(pack.createOverlay(overlay));
                    }
                    return new CompositePackResources((PackResources)pack, overlays);
                }
            }, (PackType)resourceType, (PackSelectionConfig)info2);
            consumer.accept(profile);
        }
    }

    @Override
    public void registerReloadListener(IdentifiableResourceReloadListener listener) {
        this.resourceLoader.registerReloader(listener.getFabricId(), (PreparableReloadListener)listener);
        listener.getFabricDependencies().forEach(dependency -> this.resourceLoader.addReloaderOrdering(dependency, listener.getFabricId()));
    }

    @Override
    public void registerReloadListener(Identifier identifier, final Function<HolderLookup.Provider, IdentifiableResourceReloadListener> listenerFactory) {
        this.resourceLoader.registerReloader(identifier, new PreparableReloadListener(){

            public CompletableFuture<Void> reload(PreparableReloadListener.SharedState store, Executor prepareExecutor, PreparableReloadListener.PreparationBarrier reloadSynchronizer, Executor applyExecutor) {
                HolderLookup.Provider registries = (HolderLookup.Provider)store.get(ResourceLoader.RELOADER_REGISTRY_LOOKUP_KEY);
                PreparableReloadListener resourceReloader = (PreparableReloadListener)listenerFactory.apply(registries);
                return resourceReloader.reload(store, prepareExecutor, reloadSynchronizer, applyExecutor);
            }
        });
    }
}

