/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.impl.resource.loader.FabricResourcePackProfile;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackFactory;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackUtil;
import net.fabricmc.fabric.impl.resource.loader.PlaceholderResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ResourceManagerHelperImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class ModResourcePackCreator
implements RepositorySource {
    public static final String FABRIC = "fabric";
    private static final String PROGRAMMER_ART = "programmer_art";
    private static final String HIGH_CONTRAST = "high_contrast";
    public static final Set<String> POST_CHANGE_HANDLE_REQUIRED = Set.of("fabric", "programmer_art", "high_contrast");
    @VisibleForTesting
    public static final Predicate<Set<String>> BASE_PARENT = enabled -> enabled.contains(FABRIC);
    @VisibleForTesting
    public static final Predicate<Set<String>> PROGRAMMER_ART_PARENT = enabled -> enabled.contains(FABRIC) && enabled.contains(PROGRAMMER_ART);
    @VisibleForTesting
    public static final Predicate<Set<String>> HIGH_CONTRAST_PARENT = enabled -> enabled.contains(FABRIC) && enabled.contains(HIGH_CONTRAST);
    public static final PackSource RESOURCE_PACK_SOURCE = new PackSource(){

        public Component decorate(Component packName) {
            return Component.translatable((String)"pack.nameAndSource", (Object[])new Object[]{packName, Component.translatable((String)"pack.source.fabricmod")});
        }

        public boolean shouldAddAutomatically() {
            return true;
        }
    };
    public static final ModResourcePackCreator CLIENT_RESOURCE_PACK_PROVIDER = new ModResourcePackCreator(PackType.CLIENT_RESOURCES);
    public static final int MAX_KNOWN_PACKS = Integer.getInteger("fabric-resource-loader-v0:maxKnownPacks", 1024);
    private final PackType type;
    private final PackSelectionConfig activationInfo;
    private final boolean forClientDataPackManager;

    public ModResourcePackCreator(PackType type) {
        this(type, false);
    }

    protected ModResourcePackCreator(PackType type, boolean forClientDataPackManager) {
        this.type = type;
        this.activationInfo = new PackSelectionConfig(!forClientDataPackManager, Pack.Position.TOP, false);
        this.forClientDataPackManager = forClientDataPackManager;
    }

    public void loadPacks(Consumer<Pack> consumer) {
        PackLocationInfo metadata = new PackLocationInfo(FABRIC, (Component)Component.translatable((String)"pack.name.fabricMods"), RESOURCE_PACK_SOURCE, Optional.empty());
        consumer.accept(Pack.readMetaAndCreate((PackLocationInfo)metadata, (Pack.ResourcesSupplier)new PlaceholderResourcePack.Factory(this.type, metadata), (PackType)this.type, (PackSelectionConfig)this.activationInfo));
        this.registerModPack(consumer, null, BASE_PARENT);
        if (this.type == PackType.CLIENT_RESOURCES) {
            this.registerModPack(consumer, PROGRAMMER_ART, PROGRAMMER_ART_PARENT);
            this.registerModPack(consumer, HIGH_CONTRAST, HIGH_CONTRAST_PARENT);
        }
        ResourceManagerHelperImpl.registerBuiltinResourcePacks(this.type, consumer);
    }

    private void registerModPack(Consumer<Pack> consumer, @Nullable String subPath, Predicate<Set<String>> parents) {
        List<ModResourcePack> packs = ModResourcePackUtil.getModResourcePacks(FabricLoader.getInstance(), this.type, subPath);
        for (ModResourcePack pack : packs) {
            Pack profile = Pack.readMetaAndCreate((PackLocationInfo)pack.location(), (Pack.ResourcesSupplier)new ModResourcePackFactory(pack), (PackType)this.type, (PackSelectionConfig)this.activationInfo);
            if (profile == null) continue;
            if (!this.forClientDataPackManager) {
                ((FabricResourcePackProfile)profile).fabric_setParentsPredicate(parents);
            }
            consumer.accept(profile);
        }
    }
}

