/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.world.level.block.Block;

public abstract class ColorProviderRegistryImpl<T, Provider, Underlying>
implements ColorProviderRegistry<T, Provider> {
    public static final ColorProviderRegistryImpl<Block, BlockColor, BlockColors> BLOCK = new ColorProviderRegistryImpl<Block, BlockColor, BlockColors>(){

        @Override
        void registerUnderlying(BlockColors map, BlockColor mapper, Block block) {
            map.register(mapper, new Block[]{block});
        }
    };
    private Underlying colorMap;
    private Map<T, Provider> tempMappers = new IdentityHashMap<T, Provider>();

    abstract void registerUnderlying(Underlying var1, Provider var2, T var3);

    public void initialize(Underlying colorMap) {
        if (this.colorMap != null) {
            if (this.colorMap != colorMap) {
                throw new IllegalStateException("Cannot set colorMap twice");
            }
            return;
        }
        this.colorMap = colorMap;
        for (Map.Entry<T, Provider> mappers : this.tempMappers.entrySet()) {
            this.registerUnderlying(colorMap, mappers.getValue(), mappers.getKey());
        }
        this.tempMappers = null;
    }

    @Override
    @SafeVarargs
    public final void register(Provider provider, T ... objects) {
        if (this.colorMap != null) {
            for (T object : objects) {
                this.registerUnderlying(this.colorMap, provider, object);
            }
        } else {
            for (T object : objects) {
                this.tempMappers.put(object, provider);
            }
        }
    }

    @Override
    public Provider get(T object) {
        return this.colorMap == null ? null : (Provider)((ColorMapperHolder)this.colorMap).get(object);
    }

    public static interface ColorMapperHolder<T, Provider> {
        public Provider get(T var1);
    }
}

