/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.util.HashMap;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.ArmorRenderer;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_5617;
import net.minecraft.class_7923;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ArmorRendererRegistryImpl {
    private static final HashMap<class_1792, ArmorRenderer.Factory> FACTORIES = new HashMap();
    private static final HashMap<class_1792, ArmorRenderer> RENDERERS = new HashMap();

    public static void register(ArmorRenderer.Factory factory, class_1935 ... items) {
        Objects.requireNonNull(factory, "renderer factory is null");
        if (items.length == 0) {
            throw new IllegalArgumentException("Armor renderer registered for no item");
        }
        for (class_1935 item : items) {
            Objects.requireNonNull(item.method_8389(), "armor item is null");
            if (FACTORIES.putIfAbsent(item.method_8389(), factory) == null) continue;
            throw new IllegalArgumentException("Custom armor renderer already exists for " + String.valueOf(class_7923.field_41178.method_10221((Object)item.method_8389())));
        }
    }

    public static void register(ArmorRenderer renderer, class_1935 ... items) {
        Objects.requireNonNull(renderer, "renderer is null");
        ArmorRendererRegistryImpl.register((class_5617.class_5618 context) -> renderer, items);
    }

    public static @Nullable ArmorRenderer get(class_1792 item) {
        return RENDERERS.get(item);
    }

    public static void createArmorRenderers(class_5617.class_5618 context) {
        RENDERERS.clear();
        FACTORIES.forEach((item, factory) -> RENDERERS.put((class_1792)item, factory.createArmorRenderer(context)));
    }
}

