/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.rendering.v1.world;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldExtractionContext;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldTerrainRenderContext;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_12074;
import net.minecraft.class_239;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class WorldRenderEvents {
    public static final Event<AfterBlockOutlineExtraction> AFTER_BLOCK_OUTLINE_EXTRACTION = EventFactory.createArrayBacked(AfterBlockOutlineExtraction.class, callbacks -> (context, hit) -> {
        for (AfterBlockOutlineExtraction callback : callbacks) {
            callback.afterBlockOutlineExtraction(context, hit);
        }
    });
    public static final Event<EndExtraction> END_EXTRACTION = EventFactory.createArrayBacked(EndExtraction.class, callbacks -> context -> {
        for (EndExtraction callback : callbacks) {
            callback.endExtraction(context);
        }
    });
    public static final Event<StartMain> START_MAIN = EventFactory.createArrayBacked(StartMain.class, callbacks -> context -> {
        for (StartMain callback : callbacks) {
            callback.startMain(context);
        }
    });
    public static final Event<BeforeEntities> BEFORE_ENTITIES = EventFactory.createArrayBacked(BeforeEntities.class, callbacks -> context -> {
        for (BeforeEntities callback : callbacks) {
            callback.beforeEntities(context);
        }
    });
    public static final Event<AfterEntities> AFTER_ENTITIES = EventFactory.createArrayBacked(AfterEntities.class, callbacks -> context -> {
        for (AfterEntities callback : callbacks) {
            callback.afterEntities(context);
        }
    });
    public static final Event<DebugRender> BEFORE_DEBUG_RENDER = EventFactory.createArrayBacked(DebugRender.class, callbacks -> context -> {
        for (DebugRender callback : callbacks) {
            callback.beforeDebugRender(context);
        }
    });
    public static final Event<BeforeTranslucent> BEFORE_TRANSLUCENT = EventFactory.createArrayBacked(BeforeTranslucent.class, callbacks -> context -> {
        for (BeforeTranslucent callback : callbacks) {
            callback.beforeTranslucent(context);
        }
    });
    public static final Event<BeforeBlockOutline> BEFORE_BLOCK_OUTLINE = EventFactory.createArrayBacked(BeforeBlockOutline.class, callbacks -> (context, outlineRenderState) -> {
        boolean shouldRender = true;
        for (BeforeBlockOutline callback : callbacks) {
            if (callback.beforeBlockOutline(context, outlineRenderState)) continue;
            shouldRender = false;
        }
        return shouldRender;
    });
    public static final Event<EndMain> END_MAIN = EventFactory.createArrayBacked(EndMain.class, callbacks -> context -> {
        for (EndMain callback : callbacks) {
            callback.endMain(context);
        }
    });

    private WorldRenderEvents() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface EndMain {
        public void endMain(WorldRenderContext var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface BeforeBlockOutline {
        public boolean beforeBlockOutline(WorldRenderContext var1, class_12074 var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface BeforeTranslucent {
        public void beforeTranslucent(WorldRenderContext var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface DebugRender {
        public void beforeDebugRender(WorldRenderContext var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AfterEntities {
        public void afterEntities(WorldRenderContext var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface BeforeEntities {
        public void beforeEntities(WorldRenderContext var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface StartMain {
        public void startMain(WorldTerrainRenderContext var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface EndExtraction {
        public void endExtraction(WorldExtractionContext var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AfterBlockOutlineExtraction {
        public void afterBlockOutlineExtraction(WorldExtractionContext var1, @Nullable class_239 var2);
    }
}

