/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.rendering.v1;

import java.util.Objects;
import net.fabricmc.fabric.impl.client.rendering.EntityModelLayerImpl;
import net.fabricmc.fabric.mixin.client.rendering.ModelLayersAccessor;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.entity.ArmorModelSet;

public final class EntityModelLayerRegistry {
    public static void registerModelLayer(ModelLayerLocation modelLayer, TexturedModelDataProvider provider) {
        Objects.requireNonNull(modelLayer, "EntityModelLayer cannot be null");
        Objects.requireNonNull(provider, "TexturedModelDataProvider cannot be null");
        if (EntityModelLayerImpl.PROVIDERS.putIfAbsent(modelLayer, provider) != null) {
            throw new IllegalArgumentException(String.format("Cannot replace registration for entity model layer \"%s\"", modelLayer));
        }
        ModelLayersAccessor.getLayers().add(modelLayer);
    }

    public static void registerEquipmentModelLayers(ArmorModelSet<ModelLayerLocation> equipmentModelData, TexturedEquipmentModelDataProvider provider) {
        Objects.requireNonNull(equipmentModelData, "EquipmentModelData cannot be null");
        Objects.requireNonNull(provider, "TexturedEquipmentModelDataProvider cannot be null");
        if (EntityModelLayerImpl.EQUIPMENT_PROVIDERS.putIfAbsent(equipmentModelData, provider) != null) {
            throw new IllegalArgumentException(String.format("Cannot replace registration for entity equipment model layer \"%s\"", equipmentModelData));
        }
        equipmentModelData.map(ModelLayersAccessor.getLayers()::add);
    }

    private EntityModelLayerRegistry() {
    }

    @FunctionalInterface
    public static interface TexturedEquipmentModelDataProvider {
        public ArmorModelSet<LayerDefinition> createEquipmentModelData();
    }

    @FunctionalInterface
    public static interface TexturedModelDataProvider {
        public LayerDefinition createModelData();
    }
}

