/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering.hud;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.SequencedSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntBinaryOperator;
import java.util.function.ToIntFunction;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.StatusBarHeightProvider;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.fabricmc.fabric.impl.client.rendering.hud.HudElementRegistryImpl;
import net.fabricmc.fabric.impl.client.rendering.hud.HudLayer;
import net.fabricmc.fabric.mixin.client.rendering.InGameHudAccessor;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public final class HudStatusBarHeightRegistryImpl
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-rendering-v1");
    static final int DEFAULT_HEIGHT = 39;
    static final int HELD_ITEM_TOOLTIP_HEIGHT = 20;
    static final int OVERLAY_MESSAGE_HEIGHT = 29;
    static final int TEXT_HEIGHT_DELTA = 9;
    static final StatusBarHeightProvider HEALTH_BAR = player -> {
        class_329 hud = class_310.method_1551().field_1705;
        int playerHealth = class_3532.method_15386((float)player.method_6032());
        int displayHealth = ((InGameHudAccessor)hud).fabric$getRenderHealthValue();
        float maxHealth = Math.max((float)player.method_45325(class_5134.field_23716), (float)Math.max(displayHealth, playerHealth));
        int absorptionAmount = class_3532.method_15386((float)player.method_6067());
        int healthRows = class_3532.method_15386((float)((maxHealth + (float)absorptionAmount) / 2.0f / 10.0f));
        int rowShift = Math.max(10 - (healthRows - 2), 3);
        return 10 + (healthRows - 1) * rowShift;
    };
    static final StatusBarHeightProvider ARMOR_BAR = player -> player.method_6096() > 0 ? 10 : 0;
    static final StatusBarHeightProvider MOUNT_HEALTH = player -> {
        class_329 hud = class_310.method_1551().field_1705;
        class_1309 livingEntity = ((InGameHudAccessor)hud).fabric$callGetRiddenEntity();
        int vehicleMaxHearts = ((InGameHudAccessor)hud).fabric$callGetHeartCount(livingEntity);
        return ((InGameHudAccessor)hud).fabric$callGetHeartRows(vehicleMaxHearts) * 10;
    };
    static final StatusBarHeightProvider FOOD_BAR = player -> {
        class_329 hud = class_310.method_1551().field_1705;
        class_1309 livingEntity = ((InGameHudAccessor)hud).fabric$callGetRiddenEntity();
        return ((InGameHudAccessor)hud).fabric$callGetHeartCount(livingEntity) == 0 ? 10 : 0;
    };
    static final StatusBarHeightProvider AIR_BAR = player -> {
        int maxAirSupply = player.method_5748();
        int airSupply = Math.clamp((long)player.method_5669(), 0, maxAirSupply);
        boolean isInWater = player.method_5777(class_3486.field_15517);
        return isInWater || airSupply < maxAirSupply ? 10 : 0;
    };
    static final Map<class_2960, ResolvedHeightProvider> RESOLVED_VANILLA_HEIGHT_PROVIDERS = ImmutableMap.of((Object)VanillaHudElements.HEALTH_BAR, (Object)ResolvedHeightProvider.ZERO, (Object)VanillaHudElements.ARMOR_BAR, HEALTH_BAR::getStatusBarHeight, (Object)VanillaHudElements.MOUNT_HEALTH, (Object)ResolvedHeightProvider.ZERO, (Object)VanillaHudElements.FOOD_BAR, (Object)ResolvedHeightProvider.ZERO, (Object)VanillaHudElements.AIR_BAR, (Object)HudStatusBarHeightRegistryImpl.reduceToIntFunctions(MOUNT_HEALTH, FOOD_BAR, Integer::sum));
    static final Map<class_2960, StatusBarHeightProvider> LEFT_VANILLA_HEIGHT_PROVIDERS = ImmutableMap.of((Object)VanillaHudElements.HEALTH_BAR, (Object)HEALTH_BAR, (Object)VanillaHudElements.ARMOR_BAR, (Object)ARMOR_BAR);
    static final Map<class_2960, StatusBarHeightProvider> RIGHT_VANILLA_HEIGHT_PROVIDERS = ImmutableMap.of((Object)VanillaHudElements.MOUNT_HEALTH, (Object)MOUNT_HEALTH, (Object)VanillaHudElements.FOOD_BAR, (Object)FOOD_BAR, (Object)VanillaHudElements.AIR_BAR, (Object)AIR_BAR);
    static final Map<class_2960, StatusBarHeightProvider> LEFT_HEIGHT_PROVIDERS = new HashMap<class_2960, StatusBarHeightProvider>(LEFT_VANILLA_HEIGHT_PROVIDERS);
    static final Map<class_2960, StatusBarHeightProvider> RIGHT_HEIGHT_PROVIDERS = new HashMap<class_2960, StatusBarHeightProvider>(RIGHT_VANILLA_HEIGHT_PROVIDERS);
    @Nullable
    static Map<class_2960, ResolvedHeightProvider> resolvedHeightProviders;

    public void onInitializeClient() {
        ClientLifecycleEvents.CLIENT_STARTED.register(minecraft -> HudStatusBarHeightRegistryImpl.init());
    }

    public static void addLeft(class_2960 id, StatusBarHeightProvider heightProvider) {
        if (resolvedHeightProviders != null) {
            throw new IllegalStateException("Height provider registry already frozen!");
        }
        LEFT_HEIGHT_PROVIDERS.put(id, heightProvider);
    }

    public static void addRight(class_2960 id, StatusBarHeightProvider heightProvider) {
        if (resolvedHeightProviders != null) {
            throw new IllegalStateException("Height provider registry already frozen!");
        }
        RIGHT_HEIGHT_PROVIDERS.put(id, heightProvider);
    }

    public static int getHeight(class_2960 id) {
        if (resolvedHeightProviders == null) {
            throw new IllegalStateException("Trying to get status bar height for " + String.valueOf(id) + " too early");
        }
        if (!resolvedHeightProviders.containsKey(id)) {
            throw new IllegalArgumentException("Unknown status bar: " + String.valueOf(id));
        }
        class_1657 player = ((InGameHudAccessor)class_310.method_1551().field_1705).fabric$callGetCameraPlayer();
        if (player == null) {
            throw new IllegalStateException("Trying to get status bar height for " + String.valueOf(id) + " without a camera player");
        }
        return 39 + resolvedHeightProviders.get(id).getResolvedHeight(player);
    }

    static void init() {
        if (LEFT_VANILLA_HEIGHT_PROVIDERS.equals(LEFT_HEIGHT_PROVIDERS) && RIGHT_VANILLA_HEIGHT_PROVIDERS.equals(RIGHT_HEIGHT_PROVIDERS)) {
            resolvedHeightProviders = RESOLVED_VANILLA_HEIGHT_PROVIDERS;
        } else {
            LinkedHashMap<class_2960, ResolvedHeightProvider> resolvedHeightProviders = new LinkedHashMap<class_2960, ResolvedHeightProvider>();
            ResolvedHeightProvider maxLeftHeightProvider = HudStatusBarHeightRegistryImpl.resolveHeightProviders(LEFT_HEIGHT_PROVIDERS, resolvedHeightProviders::put);
            ResolvedHeightProvider maxRightHeightProvider = HudStatusBarHeightRegistryImpl.resolveHeightProviders(RIGHT_HEIGHT_PROVIDERS, resolvedHeightProviders::put);
            HudStatusBarHeightRegistryImpl.applyVanillaHeightProviders(resolvedHeightProviders, HudStatusBarHeightRegistryImpl.reduceToIntFunctions(maxLeftHeightProvider, maxRightHeightProvider, Math::max));
            HudStatusBarHeightRegistryImpl.resolvedHeightProviders = ImmutableMap.copyOf(resolvedHeightProviders);
        }
    }

    private static ResolvedHeightProvider resolveHeightProviders(Map<class_2960, StatusBarHeightProvider> heightProviderLookup, BiConsumer<class_2960, ResolvedHeightProvider> heightProviderConsumer) {
        SequencedSet<class_2960> orderedHeightProviders = HudStatusBarHeightRegistryImpl.getOrderedHeightProviders(heightProviderLookup);
        Sets.SetView unregisteredHudElements = Sets.difference(heightProviderLookup.keySet(), orderedHeightProviders);
        if (!unregisteredHudElements.isEmpty()) {
            throw new IllegalStateException("Unregistered hud elements: " + String.valueOf(unregisteredHudElements));
        }
        for (class_2960 id : heightProviderLookup.keySet()) {
            ResolvedHeightProvider heightProvider = HudStatusBarHeightRegistryImpl.resolveHeightProvider(id, heightProviderLookup, orderedHeightProviders);
            heightProviderConsumer.accept(id, heightProvider);
        }
        return HudStatusBarHeightRegistryImpl.resolveMaximumHeightProvider((class_2960)orderedHeightProviders.getLast(), heightProviderLookup, orderedHeightProviders);
    }

    private static SequencedSet<class_2960> getOrderedHeightProviders(Map<class_2960, StatusBarHeightProvider> heightProviderLookup) {
        LinkedHashSet<class_2960> orderedHeightProviders = new LinkedHashSet<class_2960>();
        for (class_2960 class_29602 : RESOLVED_VANILLA_HEIGHT_PROVIDERS.keySet()) {
            for (HudLayer hudLayer : HudElementRegistryImpl.ROOT_ELEMENTS.get(class_29602).layers()) {
                HudStatusBarHeightRegistryImpl.addOrderedHeightProvider(hudLayer, heightProviderLookup, orderedHeightProviders::add);
            }
        }
        for (Map.Entry entry : HudElementRegistryImpl.ROOT_ELEMENTS.entrySet()) {
            if (RESOLVED_VANILLA_HEIGHT_PROVIDERS.containsKey(entry.getKey())) continue;
            for (HudLayer hudLayer : ((HudElementRegistryImpl.RootLayer)entry.getValue()).layers()) {
                HudStatusBarHeightRegistryImpl.addOrderedHeightProvider(hudLayer, heightProviderLookup, orderedHeightProviders::add);
            }
        }
        return orderedHeightProviders;
    }

    private static void addOrderedHeightProvider(HudLayer hudLayer, Map<class_2960, StatusBarHeightProvider> heightProviderLookup, Consumer<class_2960> heightProviderConsumer) {
        if (!hudLayer.isRemoved() && heightProviderLookup.containsKey(hudLayer.id())) {
            heightProviderConsumer.accept(hudLayer.id());
        }
    }

    private static ResolvedHeightProvider resolveHeightProvider(class_2960 id, Map<class_2960, StatusBarHeightProvider> heightProviderLookup, SequencedCollection<class_2960> orderedHeightProviders) {
        ResolvedHeightProvider heightProvider = ResolvedHeightProvider.ZERO;
        for (class_2960 heightProviderLocation : orderedHeightProviders) {
            if (heightProviderLocation.equals((Object)id)) {
                return heightProvider;
            }
            if (!heightProviderLookup.containsKey(heightProviderLocation)) continue;
            heightProvider = HudStatusBarHeightRegistryImpl.reduceToIntFunctions(heightProvider, heightProviderLookup.get(heightProviderLocation), Integer::sum);
        }
        throw new IllegalStateException("Unknown height provider: " + String.valueOf(id));
    }

    private static ResolvedHeightProvider resolveMaximumHeightProvider(class_2960 id, Map<class_2960, StatusBarHeightProvider> heightProviderLookup, SequencedCollection<class_2960> orderedHeightProviders) {
        ResolvedHeightProvider heightProvider = HudStatusBarHeightRegistryImpl.resolveHeightProvider(id, heightProviderLookup, orderedHeightProviders);
        return HudStatusBarHeightRegistryImpl.reduceToIntFunctions(heightProviderLookup.get(id), heightProvider, Integer::sum);
    }

    private static ResolvedHeightProvider reduceToIntFunctions(ToIntFunction<class_1657> first, ToIntFunction<class_1657> second, IntBinaryOperator operator) {
        return player -> operator.applyAsInt(first.applyAsInt(player), second.applyAsInt(player));
    }

    private static void applyVanillaHeightProviders(Map<class_2960, ResolvedHeightProvider> resolvedHeightProviders, ResolvedHeightProvider maxHeightProvider) {
        for (Map.Entry<class_2960, ResolvedHeightProvider> entry : RESOLVED_VANILLA_HEIGHT_PROVIDERS.entrySet()) {
            if (HudStatusBarHeightRegistryImpl.isVanillaHeightProvider(entry.getKey())) {
                ResolvedHeightProvider expectedHeightProvider = entry.getValue();
                ResolvedHeightProvider actualHeightProvider = resolvedHeightProviders.put(entry.getKey(), expectedHeightProvider);
                Objects.requireNonNull(actualHeightProvider, () -> "resolved height provider " + String.valueOf(entry.getKey()) + " is null");
                HudStatusBarHeightRegistryImpl.replaceVanillaElement(entry.getKey(), HudStatusBarHeightRegistryImpl.reduceToIntFunctions(expectedHeightProvider, actualHeightProvider, (i1, i2) -> i1 - i2));
                continue;
            }
            LOGGER.debug("Skipped wrapping hud element {} for applying height provider offsets", (Object)entry.getKey());
        }
        HudStatusBarHeightRegistryImpl.replaceVanillaElement(VanillaHudElements.HELD_ITEM_TOOLTIP, player -> 20 - Math.max(20, maxHeightProvider.getResolvedHeight(player)));
        HudStatusBarHeightRegistryImpl.replaceVanillaElement(VanillaHudElements.OVERLAY_MESSAGE, player -> 29 - Math.max(29, maxHeightProvider.getResolvedHeight(player) + 9));
    }

    private static boolean isVanillaHeightProvider(class_2960 id) {
        if (LEFT_HEIGHT_PROVIDERS.containsKey(id) && LEFT_HEIGHT_PROVIDERS.get(id) == LEFT_VANILLA_HEIGHT_PROVIDERS.get(id)) {
            return true;
        }
        return RIGHT_HEIGHT_PROVIDERS.containsKey(id) && RIGHT_HEIGHT_PROVIDERS.get(id) == RIGHT_VANILLA_HEIGHT_PROVIDERS.get(id);
    }

    private static void replaceVanillaElement(class_2960 id, ResolvedHeightProvider heightProvider) {
        HudElementRegistry.replaceElement(id, layer -> (context, tickCounter) -> {
            int height;
            class_1657 player = ((InGameHudAccessor)class_310.method_1551().field_1705).fabric$callGetCameraPlayer();
            int n = height = player != null ? heightProvider.getResolvedHeight(player) : 0;
            if (height != 0) {
                context.method_51448().pushMatrix();
                context.method_51448().translate(0.0f, (float)height);
            }
            layer.render(context, tickCounter);
            if (height != 0) {
                context.method_51448().popMatrix();
            }
        });
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ResolvedHeightProvider
    extends ToIntFunction<class_1657> {
        public static final ResolvedHeightProvider ZERO = player -> 0;

        public int getResolvedHeight(class_1657 var1);

        @Override
        @ApiStatus.NonExtendable
        default public int applyAsInt(class_1657 player) {
            return this.getResolvedHeight(player);
        }
    }
}

