/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering.fluid;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRendering;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderHandlerInfo;
import net.minecraft.client.renderer.block.LiquidBlockRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class FluidRenderingImpl {
    private static final ThreadLocal<FluidRendering.DefaultRenderer> CURRENT_DEFAULT_RENDERER = new ThreadLocal();
    private static final ThreadLocal<FluidRenderHandlerInfo> CURRENT_INFO = ThreadLocal.withInitial(FluidRenderHandlerInfo::new);
    private static LiquidBlockRenderer vanillaRenderer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(FluidRenderHandler handler, BlockAndTintGetter level, BlockPos pos, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState, FluidRendering.DefaultRenderer defaultRenderer) {
        CURRENT_DEFAULT_RENDERER.set(defaultRenderer);
        try {
            handler.renderFluid(pos, level, vertexConsumer, blockState, fluidState);
        }
        finally {
            CURRENT_DEFAULT_RENDERER.remove();
        }
    }

    public static void renderDefault(FluidRenderHandler handler, BlockAndTintGetter level, BlockPos pos, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState) {
        FluidRendering.DefaultRenderer renderer = CURRENT_DEFAULT_RENDERER.get();
        if (renderer != null) {
            renderer.render(handler, level, pos, vertexConsumer, blockState, fluidState);
        } else {
            FluidRenderingImpl.renderVanillaDefault(handler, level, pos, vertexConsumer, blockState, fluidState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderVanillaDefault(FluidRenderHandler handler, BlockAndTintGetter level, BlockPos pos, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState) {
        FluidRenderHandlerInfo info = CURRENT_INFO.get();
        info.setup(handler, level, pos, fluidState);
        try {
            vanillaRenderer.tesselate(level, pos, vertexConsumer, blockState, fluidState);
        }
        finally {
            info.clear();
        }
    }

    public static void setVanillaRenderer(LiquidBlockRenderer vanillaRenderer) {
        FluidRenderingImpl.vanillaRenderer = vanillaRenderer;
    }

    public static FluidRenderHandlerInfo getCurrentInfo() {
        return CURRENT_INFO.get();
    }
}

