/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.rendering.fluid;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Definitions;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderHandlerInfo;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderHandlerRegistryImpl;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderingImpl;
import net.minecraft.client.renderer.block.LiquidBlockRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LiquidBlockRenderer.class})
public class LiquidBlockRendererMixin {
    @Final
    @Shadow
    private TextureAtlasSprite[] lavaIcons;
    @Final
    @Shadow
    private TextureAtlasSprite[] waterIcons;
    @Shadow
    private TextureAtlasSprite waterOverlay;

    @Inject(method={"setupSprites"}, at={@At(value="RETURN")})
    public void onResourceReloadReturn(CallbackInfo info) {
        LiquidBlockRenderer self = (LiquidBlockRenderer)this;
        ((FluidRenderHandlerRegistryImpl)FluidRenderHandlerRegistry.INSTANCE).onFluidRendererReload(self, this.waterIcons, this.lavaIcons, this.waterOverlay);
    }

    @Inject(method={"tesselate"}, at={@At(value="HEAD")}, cancellable=true)
    public void onHeadRender(BlockAndTintGetter view, BlockPos pos, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState, CallbackInfo ci) {
        FluidRenderHandler handler;
        FluidRenderHandlerInfo info = FluidRenderingImpl.getCurrentInfo();
        if (info.handler == null && (handler = FluidRenderHandlerRegistry.INSTANCE.get(fluidState.getType())) != null) {
            handler.renderFluid(pos, view, vertexConsumer, blockState, fluidState);
            ci.cancel();
        }
    }

    @ModifyVariable(method={"tesselate"}, at=@At(value="STORE"), ordinal=0)
    public TextureAtlasSprite[] modSpriteArray(TextureAtlasSprite[] original) {
        FluidRenderHandlerInfo info = FluidRenderingImpl.getCurrentInfo();
        return info.handler != null ? info.sprites : original;
    }

    @ModifyExpressionValue(method={"tesselate"}, at={@At(value="CONSTANT", args={"intValue=16777215"}), @At(value="INVOKE", target="Lnet/minecraft/client/renderer/BiomeColors;getAverageWaterColor(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/core/BlockPos;)I")})
    public int modTintColor(int original, BlockAndTintGetter world, BlockPos pos, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState) {
        FluidRenderHandlerInfo info = FluidRenderingImpl.getCurrentInfo();
        return info.handler != null ? info.handler.getFluidColor(world, pos, fluidState) : original;
    }

    @ModifyVariable(method={"tesselate"}, at=@At(value="MIXINEXTRAS:EXPRESSION", ordinal=0), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/client/renderer/block/LiquidBlockRenderer;waterOverlay:Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;")))
    @Definitions(value={@Definition(id="getFrameU", method={"Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;getU(F)F"}), @Definition(id="sprite2", local={@Local(type=TextureAtlasSprite.class)})})
    @Expression(value={"@(sprite2).getFrameU(0.0)"})
    private TextureAtlasSprite modifyOverlaySprite(TextureAtlasSprite sprite2, BlockAndTintGetter world, @Local(ordinal=1) BlockPos neighborPos, @Local(ordinal=0) boolean isLava, @Local TextureAtlasSprite[] sprites, @Share(value="useOverlay") LocalBooleanRef useOverlay) {
        FluidRenderHandlerInfo info = FluidRenderingImpl.getCurrentInfo();
        boolean hasOverlay = info.handler != null ? info.hasOverlay : !isLava;
        Block neighborBlock = world.getBlockState(neighborPos).getBlock();
        useOverlay.set(hasOverlay && FluidRenderHandlerRegistry.INSTANCE.isBlockTransparent(neighborBlock));
        if (useOverlay.get()) {
            return info.handler != null ? info.overlaySprite : this.waterOverlay;
        }
        return sprites[1];
    }

    @ModifyExpressionValue(method={"tesselate"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="sprite2", local={@Local(type=TextureAtlasSprite.class)}), @Definition(id="waterOverlaySprite", field={"Lnet/minecraft/client/renderer/block/LiquidBlockRenderer;waterOverlay:Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;"})})
    @Expression(value={"sprite2 != this.waterOverlaySprite"})
    private boolean modifyNonOverlayCheck(boolean original, @Share(value="useOverlay") LocalBooleanRef useOverlay) {
        return !useOverlay.get();
    }
}

