/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.Arrays;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractTerrainRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.LightDataProvider;
import net.minecraft.class_1087;
import net.minecraft.class_11515;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_4076;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_761;

@Environment(value=EnvType.CLIENT)
public class TerrainRenderContext
extends AbstractTerrainRenderContext {
    public static final ThreadLocal<TerrainRenderContext> POOL = ThreadLocal.withInitial(TerrainRenderContext::new);
    private class_4587 matrixStack;
    private class_5819 random;
    private Function<class_11515, class_287> bufferFunc;

    public TerrainRenderContext() {
        this.overlay = class_4608.field_21444;
    }

    @Override
    protected LightDataProvider createLightDataProvider(BlockRenderInfo blockInfo) {
        return new LightDataCache(blockInfo);
    }

    @Override
    protected class_4588 getVertexConsumer(class_11515 layer) {
        return (class_4588)this.bufferFunc.apply(layer);
    }

    public void prepare(class_1920 blockView, class_2338 sectionOrigin, class_4587 matrixStack, class_5819 random, Function<class_11515, class_287> bufferFunc) {
        this.blockInfo.prepareForWorld(blockView, true);
        ((LightDataCache)this.lightDataProvider).prepare(sectionOrigin);
        this.matrixStack = matrixStack;
        this.random = random;
        this.bufferFunc = bufferFunc;
    }

    public void release() {
        this.matrices = null;
        this.matrixStack = null;
        this.random = null;
        this.bufferFunc = null;
        this.blockInfo.release();
    }

    public void bufferModel(class_1087 model, class_2680 blockState, class_2338 blockPos) {
        this.matrixStack.method_22903();
        try {
            this.matrixStack.method_46416((float)class_4076.method_18684((int)blockPos.method_10263()), (float)class_4076.method_18684((int)blockPos.method_10264()), (float)class_4076.method_18684((int)blockPos.method_10260()));
            class_243 offset = blockState.method_26226(blockPos);
            this.matrixStack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
            this.matrices = this.matrixStack.method_23760();
            this.random.method_43052(blockState.method_26190(blockPos));
            this.prepare(blockPos, blockState);
            model.emitQuads(this.getEmitter(), this.blockInfo.blockView, blockPos, blockState, this.random, this.blockInfo::shouldCullSide);
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Tessellating block in world - Indigo Renderer");
            class_129 crashReportSection = crashReport.method_562("Block being tessellated");
            class_129.method_586((class_129)crashReportSection, (class_5539)this.blockInfo.blockView, (class_2338)blockPos, (class_2680)blockState);
            throw new class_148(crashReport);
        }
        finally {
            this.matrixStack.method_22909();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class LightDataCache
    implements LightDataProvider {
        private final int[] lightCache = new int[5832];
        private final float[] aoCache = new float[5832];
        private final BlockRenderInfo blockInfo;
        private class_2338 sectionOrigin;
        private final class_761.class_10948 lightGetter = (world, pos) -> {
            int cacheIndex = this.cacheIndex(pos);
            if (cacheIndex == -1) {
                return class_761.class_10948.field_58200.packedBrightness(world, pos);
            }
            int result = this.lightCache[cacheIndex];
            if (result == Integer.MAX_VALUE) {
                this.lightCache[cacheIndex] = result = class_761.class_10948.field_58200.packedBrightness(world, pos);
            }
            return result;
        };

        LightDataCache(BlockRenderInfo blockInfo) {
            this.blockInfo = blockInfo;
        }

        public void prepare(class_2338 sectionOrigin) {
            this.sectionOrigin = sectionOrigin;
            Arrays.fill(this.lightCache, Integer.MAX_VALUE);
            Arrays.fill(this.aoCache, Float.NaN);
        }

        @Override
        public int light(class_2338 pos, class_2680 state) {
            return class_761.method_23793((class_761.class_10948)this.lightGetter, (class_1920)this.blockInfo.blockView, (class_2680)state, (class_2338)pos);
        }

        @Override
        public float ao(class_2338 pos, class_2680 state) {
            int cacheIndex = this.cacheIndex(pos);
            if (cacheIndex == -1) {
                return AoLuminanceFix.INSTANCE.apply((class_1922)this.blockInfo.blockView, pos, state);
            }
            float result = this.aoCache[cacheIndex];
            if (Float.isNaN(result)) {
                this.aoCache[cacheIndex] = result = AoLuminanceFix.INSTANCE.apply((class_1922)this.blockInfo.blockView, pos, state);
            }
            return result;
        }

        private int cacheIndex(class_2338 pos) {
            int localX = pos.method_10263() - (this.sectionOrigin.method_10263() - 1);
            if (localX < 0 || localX >= 18) {
                return -1;
            }
            int localY = pos.method_10264() - (this.sectionOrigin.method_10264() - 1);
            if (localY < 0 || localY >= 18) {
                return -1;
            }
            int localZ = pos.method_10260() - (this.sectionOrigin.method_10260() - 1);
            if (localZ < 0 || localZ >= 18) {
                return -1;
            }
            return localZ * 18 * 18 + localY * 18 + localX;
        }
    }
}

