/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.mesh;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadAtlas;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadTransform;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.ShadeMode;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.NormalHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.QuadViewImpl;
import net.minecraft.class_11515;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_5611;
import net.minecraft.class_765;
import net.minecraft.class_777;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class MutableQuadViewImpl
extends QuadViewImpl
implements QuadEmitter {
    private static final QuadTransform NO_TRANSFORM = q -> true;
    private static final int[] DEFAULT_QUAD_DATA = new int[EncodingFormat.TOTAL_STRIDE];
    private QuadTransform activeTransform = NO_TRANSFORM;
    private final ObjectArrayList<QuadTransform> transformStack = new ObjectArrayList();
    private final QuadTransform stackTransform = q -> {
        int i = this.transformStack.size() - 1;
        while (i >= 0) {
            if (((QuadTransform)this.transformStack.get(i--)).transform(q)) continue;
            return false;
        }
        return true;
    };

    public final void clear() {
        System.arraycopy(DEFAULT_QUAD_DATA, 0, this.data, this.baseIndex, EncodingFormat.TOTAL_STRIDE);
        this.isGeometryInvalid = true;
        this.nominalFace = null;
    }

    public final MutableQuadViewImpl pos(int vertexIndex, float x, float y, float z) {
        int index = this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_X;
        this.data[index] = Float.floatToRawIntBits(x);
        this.data[index + 1] = Float.floatToRawIntBits(y);
        this.data[index + 2] = Float.floatToRawIntBits(z);
        this.isGeometryInvalid = true;
        return this;
    }

    public final MutableQuadViewImpl color(int vertexIndex, int color) {
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_COLOR] = color;
        return this;
    }

    public final MutableQuadViewImpl uv(int vertexIndex, float u, float v) {
        int i = this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_U;
        this.data[i] = Float.floatToRawIntBits(u);
        this.data[i + 1] = Float.floatToRawIntBits(v);
        return this;
    }

    public final MutableQuadViewImpl lightmap(int vertexIndex, int lightmap) {
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_LIGHTMAP] = lightmap;
        return this;
    }

    protected final void normalFlags(int flags) {
        this.data[this.baseIndex + 0] = EncodingFormat.normalFlags(this.data[this.baseIndex + 0], flags);
    }

    public final MutableQuadViewImpl normal(int vertexIndex, float x, float y, float z) {
        this.normalFlags(this.normalFlags() | 1 << vertexIndex);
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_NORMAL] = NormalHelper.packNormal(x, y, z);
        return this;
    }

    public final void populateMissingNormals() {
        int normalFlags = this.normalFlags();
        if (normalFlags == 15) {
            return;
        }
        int packedFaceNormal = this.packedFaceNormal();
        for (int v = 0; v < 4; ++v) {
            if ((normalFlags & 1 << v) != 0) continue;
            this.data[this.baseIndex + v * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_NORMAL] = packedFaceNormal;
        }
        this.normalFlags(15);
    }

    public final MutableQuadViewImpl nominalFace(@Nullable class_2350 face) {
        this.nominalFace = face;
        return this;
    }

    public final MutableQuadViewImpl cullFace(@Nullable class_2350 face) {
        this.data[this.baseIndex + 0] = EncodingFormat.cullFace(this.data[this.baseIndex + 0], face);
        this.nominalFace(face);
        return this;
    }

    public MutableQuadViewImpl renderLayer(@Nullable class_11515 renderLayer) {
        this.data[this.baseIndex + 0] = EncodingFormat.renderLayer(this.data[this.baseIndex + 0], renderLayer);
        return this;
    }

    public MutableQuadViewImpl emissive(boolean emissive) {
        this.data[this.baseIndex + 0] = EncodingFormat.emissive(this.data[this.baseIndex + 0], emissive);
        return this;
    }

    public MutableQuadViewImpl diffuseShade(boolean shade) {
        this.data[this.baseIndex + 0] = EncodingFormat.diffuseShade(this.data[this.baseIndex + 0], shade);
        return this;
    }

    public MutableQuadViewImpl ambientOcclusion(TriState ao) {
        Objects.requireNonNull(ao, "ambient occlusion TriState may not be null");
        this.data[this.baseIndex + 0] = EncodingFormat.ambientOcclusion(this.data[this.baseIndex + 0], ao);
        return this;
    }

    public MutableQuadViewImpl glint(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_10444.class_10445 glint) {
        this.data[this.baseIndex + 0] = EncodingFormat.glint(this.data[this.baseIndex + 0], glint);
        return this;
    }

    public MutableQuadViewImpl shadeMode(ShadeMode mode) {
        Objects.requireNonNull(mode, "ShadeMode may not be null");
        this.data[this.baseIndex + 0] = EncodingFormat.shadeMode(this.data[this.baseIndex + 0], mode);
        return this;
    }

    public MutableQuadViewImpl atlas(QuadAtlas quadAtlas) {
        this.data[this.baseIndex + 0] = EncodingFormat.quadAtlas(this.data[this.baseIndex + 0], quadAtlas);
        return this;
    }

    public final MutableQuadViewImpl tintIndex(int tintIndex) {
        this.data[this.baseIndex + 2] = tintIndex;
        return this;
    }

    public final MutableQuadViewImpl tag(int tag) {
        this.data[this.baseIndex + 3] = tag;
        return this;
    }

    public final MutableQuadViewImpl copyFrom(QuadView quad) {
        QuadViewImpl q = (QuadViewImpl)quad;
        System.arraycopy(q.data, q.baseIndex, this.data, this.baseIndex, EncodingFormat.TOTAL_STRIDE);
        this.nominalFace = q.nominalFace;
        this.isGeometryInvalid = q.isGeometryInvalid;
        if (!this.isGeometryInvalid) {
            this.faceNormal.set((Vector3fc)q.faceNormal);
        }
        return this;
    }

    public final MutableQuadViewImpl fromBakedQuad(class_777 quad) {
        this.pos(0, quad.comp_5238());
        this.pos(1, quad.comp_5239());
        this.pos(2, quad.comp_5240());
        this.pos(3, quad.comp_5241());
        this.color(-1, -1, -1, -1);
        long packedUV0 = quad.comp_5242();
        long packedUV1 = quad.comp_5243();
        long packedUV2 = quad.comp_5244();
        long packedUV3 = quad.comp_5245();
        this.uv(0, class_5611.method_76641((long)packedUV0), class_5611.method_76642((long)packedUV0));
        this.uv(1, class_5611.method_76641((long)packedUV1), class_5611.method_76642((long)packedUV1));
        this.uv(2, class_5611.method_76641((long)packedUV2), class_5611.method_76642((long)packedUV2));
        this.uv(3, class_5611.method_76641((long)packedUV3), class_5611.method_76642((long)packedUV3));
        int lightEmission = quad.comp_3726();
        int lightmap = class_765.method_23687((int)lightEmission, (int)lightEmission);
        this.lightmap(lightmap, lightmap, lightmap, lightmap);
        this.normalFlags(0);
        this.nominalFace(quad.comp_3723());
        this.emissive(lightEmission == 15);
        this.diffuseShade(quad.comp_3725());
        QuadAtlas atlas = QuadAtlas.of((class_2960)quad.comp_3724().method_45852());
        if (atlas == null) {
            atlas = QuadAtlas.BLOCK;
        }
        this.atlas(atlas);
        this.tintIndex(quad.comp_3722());
        return this;
    }

    public void pushTransform(QuadTransform transform) {
        if (transform == null) {
            throw new NullPointerException("QuadTransform cannot be null!");
        }
        this.transformStack.push((Object)transform);
        if (this.transformStack.size() == 1) {
            this.activeTransform = transform;
        } else if (this.transformStack.size() == 2) {
            this.activeTransform = this.stackTransform;
        }
    }

    public void popTransform() {
        this.transformStack.pop();
        if (this.transformStack.isEmpty()) {
            this.activeTransform = NO_TRANSFORM;
        } else if (this.transformStack.size() == 1) {
            this.activeTransform = (QuadTransform)this.transformStack.getFirst();
        }
    }

    protected abstract void emitDirectly();

    public final void transformAndEmit() {
        if (this.activeTransform.transform((MutableQuadView)this)) {
            this.emitDirectly();
        }
    }

    public final MutableQuadViewImpl emit() {
        this.transformAndEmit();
        this.clear();
        return this;
    }

    static {
        MutableQuadViewImpl quad = new MutableQuadViewImpl(){

            @Override
            protected void emitDirectly() {
            }
        };
        quad.data = DEFAULT_QUAD_DATA;
        quad.color(-1, -1, -1, -1);
        quad.cullFace(null);
        quad.renderLayer(null);
        quad.diffuseShade(true);
        quad.ambientOcclusion(TriState.DEFAULT);
        quad.glint(null);
        quad.tintIndex(-1);
    }
}

