/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.MatrixUtil;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderLayerHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.fabric.mixin.client.indigo.renderer.ItemRendererAccessor;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Matrix4f;
import org.jspecify.annotations.Nullable;

public class ItemRenderContext
extends AbstractRenderContext {
    private static final int GLINT_COUNT = ItemStackRenderState.FoilType.values().length;
    private ItemDisplayContext displayContext;
    private MultiBufferSource vertexConsumers;
    private int light;
    private int[] tints;
    private RenderType defaultLayer;
    private ItemStackRenderState.FoilType defaultGlint;
    private boolean ignoreQuadGlint;
    private PoseStack.Pose specialGlintEntry;
    private final VertexConsumer[] vertexConsumerCache = new VertexConsumer[3 * GLINT_COUNT];

    public void renderItem(ItemDisplayContext displayContext, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light, int overlay, int[] tints, List<BakedQuad> vanillaQuads, MeshView mesh, RenderType layer, ItemStackRenderState.FoilType glint, boolean ignoreQuadGlint) {
        this.displayContext = displayContext;
        this.matrices = matrixStack.last();
        this.vertexConsumers = vertexConsumers;
        this.light = light;
        this.overlay = overlay;
        this.tints = tints;
        this.defaultLayer = layer;
        this.defaultGlint = glint;
        this.ignoreQuadGlint = ignoreQuadGlint;
        this.bufferQuads(vanillaQuads, mesh);
        this.matrices = null;
        this.vertexConsumers = null;
        this.tints = null;
        this.defaultLayer = null;
        this.specialGlintEntry = null;
        Arrays.fill(this.vertexConsumerCache, null);
    }

    private void bufferQuads(List<BakedQuad> vanillaQuads, MeshView mesh) {
        QuadEmitter emitter = this.getEmitter();
        int vanillaQuadCount = vanillaQuads.size();
        for (int i = 0; i < vanillaQuadCount; ++i) {
            BakedQuad q = vanillaQuads.get(i);
            emitter.fromBakedQuad(q);
            emitter.emit();
        }
        mesh.outputTo(emitter);
    }

    @Override
    protected void bufferQuad(MutableQuadViewImpl quad) {
        VertexConsumer vertexConsumer = this.getVertexConsumer(quad.renderLayer(), quad.glint());
        this.tintQuad(quad);
        this.shadeQuad(quad, quad.emissive());
        this.bufferQuad(quad, vertexConsumer);
    }

    private void tintQuad(MutableQuadViewImpl quad) {
        int tintIndex = quad.tintIndex();
        if (tintIndex >= 0 && tintIndex < this.tints.length) {
            int tint = this.tints[tintIndex];
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ARGB.multiply((int)quad.color(i), (int)tint));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean emissive) {
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, 0xF000F0);
            }
        } else {
            int light = this.light;
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, ColorHelper.maxLight(quad.lightmap(i), light));
            }
        }
    }

    private VertexConsumer getVertexConsumer(@Nullable ChunkSectionLayer quadRenderLayer, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ItemStackRenderState.FoilType quadGlint) {
        RenderType layer = quadRenderLayer == null ? this.defaultLayer : RenderLayerHelper.getEntityBlockLayer((ChunkSectionLayer)quadRenderLayer);
        ItemStackRenderState.FoilType glint = this.ignoreQuadGlint || quadGlint == null ? this.defaultGlint : quadGlint;
        int cacheIndex = layer == Sheets.translucentItemSheet() ? 0 : (layer == Sheets.cutoutBlockSheet() ? GLINT_COUNT : 2 * GLINT_COUNT);
        VertexConsumer vertexConsumer = this.vertexConsumerCache[cacheIndex += glint.ordinal()];
        if (vertexConsumer == null) {
            this.vertexConsumerCache[cacheIndex] = vertexConsumer = this.createVertexConsumer(layer, glint);
        }
        return vertexConsumer;
    }

    private VertexConsumer createVertexConsumer(RenderType layer, ItemStackRenderState.FoilType glint) {
        if (glint == ItemStackRenderState.FoilType.SPECIAL) {
            if (this.specialGlintEntry == null) {
                this.specialGlintEntry = this.matrices.copy();
                if (this.displayContext == ItemDisplayContext.GUI) {
                    MatrixUtil.mulComponentWise((Matrix4f)this.specialGlintEntry.pose(), (float)0.5f);
                } else if (this.displayContext.firstPerson()) {
                    MatrixUtil.mulComponentWise((Matrix4f)this.specialGlintEntry.pose(), (float)0.75f);
                }
            }
            return ItemRendererAccessor.fabric_getDynamicDisplayGlintConsumer(this.vertexConsumers, layer, this.specialGlintEntry);
        }
        return ItemRenderer.getFoilBuffer((MultiBufferSource)this.vertexConsumers, (RenderType)layer, (boolean)true, (glint != ItemStackRenderState.FoilType.NONE ? 1 : 0) != 0);
    }
}

