/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.mesh;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadTransform;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.ShadeMode;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.NormalHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.QuadViewImpl;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.Direction;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public abstract class MutableQuadViewImpl
extends QuadViewImpl
implements QuadEmitter {
    private static final QuadTransform NO_TRANSFORM = q -> true;
    private static final int[] DEFAULT_QUAD_DATA = new int[EncodingFormat.TOTAL_STRIDE];
    private QuadTransform activeTransform = NO_TRANSFORM;
    private final ObjectArrayList<QuadTransform> transformStack = new ObjectArrayList();
    private final QuadTransform stackTransform = q -> {
        int i = this.transformStack.size() - 1;
        while (i >= 0) {
            if (((QuadTransform)this.transformStack.get(i--)).transform(q)) continue;
            return false;
        }
        return true;
    };

    public final void clear() {
        System.arraycopy(DEFAULT_QUAD_DATA, 0, this.data, this.baseIndex, EncodingFormat.TOTAL_STRIDE);
        this.isGeometryInvalid = true;
        this.nominalFace = null;
    }

    public final MutableQuadViewImpl pos(int vertexIndex, float x, float y, float z) {
        int index = this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_X;
        this.data[index] = Float.floatToRawIntBits(x);
        this.data[index + 1] = Float.floatToRawIntBits(y);
        this.data[index + 2] = Float.floatToRawIntBits(z);
        this.isGeometryInvalid = true;
        return this;
    }

    public final MutableQuadViewImpl color(int vertexIndex, int color) {
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_COLOR] = color;
        return this;
    }

    public final MutableQuadViewImpl uv(int vertexIndex, float u, float v) {
        int i = this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_U;
        this.data[i] = Float.floatToRawIntBits(u);
        this.data[i + 1] = Float.floatToRawIntBits(v);
        return this;
    }

    public final MutableQuadViewImpl lightmap(int vertexIndex, int lightmap) {
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_LIGHTMAP] = lightmap;
        return this;
    }

    protected final void normalFlags(int flags) {
        this.data[this.baseIndex + 0] = EncodingFormat.normalFlags(this.data[this.baseIndex + 0], flags);
    }

    public final MutableQuadViewImpl normal(int vertexIndex, float x, float y, float z) {
        this.normalFlags(this.normalFlags() | 1 << vertexIndex);
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_NORMAL] = NormalHelper.packNormal(x, y, z);
        return this;
    }

    public final void populateMissingNormals() {
        int normalFlags = this.normalFlags();
        if (normalFlags == 15) {
            return;
        }
        int packedFaceNormal = this.packedFaceNormal();
        for (int v = 0; v < 4; ++v) {
            if ((normalFlags & 1 << v) != 0) continue;
            this.data[this.baseIndex + v * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_NORMAL] = packedFaceNormal;
        }
        this.normalFlags(15);
    }

    public final MutableQuadViewImpl nominalFace(@Nullable Direction face) {
        this.nominalFace = face;
        return this;
    }

    public final MutableQuadViewImpl cullFace(@Nullable Direction face) {
        this.data[this.baseIndex + 0] = EncodingFormat.cullFace(this.data[this.baseIndex + 0], face);
        this.nominalFace(face);
        return this;
    }

    public MutableQuadViewImpl renderLayer(@Nullable ChunkSectionLayer renderLayer) {
        this.data[this.baseIndex + 0] = EncodingFormat.renderLayer(this.data[this.baseIndex + 0], renderLayer);
        return this;
    }

    public MutableQuadViewImpl emissive(boolean emissive) {
        this.data[this.baseIndex + 0] = EncodingFormat.emissive(this.data[this.baseIndex + 0], emissive);
        return this;
    }

    public MutableQuadViewImpl diffuseShade(boolean shade) {
        this.data[this.baseIndex + 0] = EncodingFormat.diffuseShade(this.data[this.baseIndex + 0], shade);
        return this;
    }

    public MutableQuadViewImpl ambientOcclusion(TriState ao) {
        Objects.requireNonNull(ao, "ambient occlusion TriState may not be null");
        this.data[this.baseIndex + 0] = EncodingFormat.ambientOcclusion(this.data[this.baseIndex + 0], ao);
        return this;
    }

    public MutableQuadViewImpl glint(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ItemStackRenderState.FoilType glint) {
        this.data[this.baseIndex + 0] = EncodingFormat.glint(this.data[this.baseIndex + 0], glint);
        return this;
    }

    public MutableQuadViewImpl shadeMode(ShadeMode mode) {
        Objects.requireNonNull(mode, "ShadeMode may not be null");
        this.data[this.baseIndex + 0] = EncodingFormat.shadeMode(this.data[this.baseIndex + 0], mode);
        return this;
    }

    public final MutableQuadViewImpl tintIndex(int tintIndex) {
        this.data[this.baseIndex + 2] = tintIndex;
        return this;
    }

    public final MutableQuadViewImpl tag(int tag) {
        this.data[this.baseIndex + 3] = tag;
        return this;
    }

    public final MutableQuadViewImpl copyFrom(QuadView quad) {
        QuadViewImpl q = (QuadViewImpl)quad;
        System.arraycopy(q.data, q.baseIndex, this.data, this.baseIndex, EncodingFormat.TOTAL_STRIDE);
        this.nominalFace = q.nominalFace;
        this.isGeometryInvalid = q.isGeometryInvalid;
        if (!this.isGeometryInvalid) {
            this.faceNormal.set((Vector3fc)q.faceNormal);
        }
        return this;
    }

    public final MutableQuadViewImpl fromVanilla(int[] vertexData, int startIndex) {
        System.arraycopy(vertexData, startIndex, this.data, this.baseIndex + 4, VANILLA_QUAD_STRIDE);
        this.isGeometryInvalid = true;
        int normalFlags = 0;
        int colorIndex = this.baseIndex + EncodingFormat.VERTEX_COLOR;
        int normalIndex = this.baseIndex + EncodingFormat.VERTEX_NORMAL;
        for (int i = 0; i < 4; ++i) {
            this.data[colorIndex] = ColorHelper.fromVanillaColor(this.data[colorIndex]);
            if ((this.data[normalIndex] & 0xFFFFFF) != 0) {
                normalFlags |= 1 << i;
            }
            colorIndex += EncodingFormat.VERTEX_STRIDE;
            normalIndex += EncodingFormat.VERTEX_STRIDE;
        }
        this.normalFlags(normalFlags);
        return this;
    }

    public final MutableQuadViewImpl fromBakedQuad(BakedQuad quad) {
        this.fromVanilla(quad.vertices(), 0);
        this.nominalFace(quad.direction());
        this.diffuseShade(quad.shade());
        this.tintIndex(quad.tintIndex());
        int lightEmission = quad.lightEmission();
        if (lightEmission > 0) {
            for (int i = 0; i < 4; ++i) {
                this.lightmap(i, LightTexture.lightCoordsWithEmission((int)this.lightmap(i), (int)lightEmission));
            }
        }
        return this;
    }

    public void pushTransform(QuadTransform transform) {
        if (transform == null) {
            throw new NullPointerException("QuadTransform cannot be null!");
        }
        this.transformStack.push((Object)transform);
        if (this.transformStack.size() == 1) {
            this.activeTransform = transform;
        } else if (this.transformStack.size() == 2) {
            this.activeTransform = this.stackTransform;
        }
    }

    public void popTransform() {
        this.transformStack.pop();
        if (this.transformStack.size() == 0) {
            this.activeTransform = NO_TRANSFORM;
        } else if (this.transformStack.size() == 1) {
            this.activeTransform = (QuadTransform)this.transformStack.get(0);
        }
    }

    protected abstract void emitDirectly();

    public final void transformAndEmit() {
        if (this.activeTransform.transform((MutableQuadView)this)) {
            this.emitDirectly();
        }
    }

    public final MutableQuadViewImpl emit() {
        this.transformAndEmit();
        this.clear();
        return this;
    }

    static {
        MutableQuadViewImpl quad = new MutableQuadViewImpl(){

            @Override
            protected void emitDirectly() {
            }
        };
        quad.data = DEFAULT_QUAD_DATA;
        quad.color(-1, -1, -1, -1);
        quad.cullFace(null);
        quad.renderLayer(null);
        quad.diffuseShade(true);
        quad.ambientOcclusion(TriState.DEFAULT);
        quad.glint(null);
        quad.tintIndex(-1);
    }
}

