/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.renderer.client.item;

import com.llamalad7.mixinextras.sugar.Local;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.fabricmc.fabric.impl.renderer.BasicItemModelExtension;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.data.AtlasIds;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockModelWrapper.class})
abstract class BlockModelWrapperMixin
implements ItemModel,
BasicItemModelExtension {
    @Shadow
    @Final
    @Mutable
    private boolean animated;
    @Unique
    private @Nullable Mesh mesh;

    BlockModelWrapperMixin() {
    }

    @Inject(method={"update"}, at={@At(value="RETURN")})
    private void onReturnUpdate(CallbackInfo ci, @Local ItemStackRenderState.LayerRenderState layer) {
        if (this.mesh != null) {
            this.mesh.outputTo(layer.emitter());
        }
    }

    @Override
    public void fabric_setMesh(Mesh mesh, SpriteGetter spriteGetter) {
        this.mesh = mesh;
        if (!this.animated) {
            SpriteFinder spriteFinder = spriteGetter.spriteFinder(AtlasIds.BLOCKS);
            mesh.forEach(quad -> {
                if (this.animated) {
                    return;
                }
                ItemStackRenderState.FoilType glint = quad.glint();
                if (glint != null && glint != ItemStackRenderState.FoilType.NONE || spriteFinder.find((QuadView)quad).contents().isAnimated()) {
                    this.animated = true;
                }
            });
        }
    }
}

