/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.renderer.client.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.impl.renderer.BatchingRenderCommandQueueExtension;
import net.fabricmc.fabric.impl.renderer.ExtendedBlockCommand;
import net.fabricmc.fabric.impl.renderer.ExtendedBlockStateModelCommand;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OrderedSubmitNodeCollector;
import net.minecraft.client.renderer.SpecialBlockModelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollection;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SubmitNodeCollection.class})
abstract class SubmitNodeCollectionMixin
implements OrderedSubmitNodeCollector,
BatchingRenderCommandQueueExtension {
    @Shadow
    @Final
    private SubmitNodeStorage submitNodeStorage;
    @Shadow
    private boolean wasUsed;
    @Unique
    private final List<ExtendedBlockCommand> extendedBlockCommands = new ArrayList<ExtendedBlockCommand>();
    @Unique
    private final List<ExtendedBlockStateModelCommand> extendedBlockStateModelCommands = new ArrayList<ExtendedBlockStateModelCommand>();

    SubmitNodeCollectionMixin() {
    }

    public void submitBlock(PoseStack matrices, BlockState state, int light, int overlay, int outlineColor, BlockAndTintGetter blockView, BlockPos pos) {
        this.wasUsed = true;
        this.extendedBlockCommands.add(new ExtendedBlockCommand(matrices.last().copy(), state, light, overlay, outlineColor, blockView, pos));
        ((SpecialBlockModelRenderer)Minecraft.getInstance().getModelManager().specialBlockModelRenderer().get()).renderByBlock(state.getBlock(), ItemDisplayContext.NONE, matrices, (SubmitNodeCollector)this.submitNodeStorage, light, overlay, outlineColor);
    }

    public void submitBlockStateModel(PoseStack matrices, Function<ChunkSectionLayer, RenderType> renderLayerFunction, BlockStateModel model, float r, float g, float b, int light, int overlay, int outlineColor, BlockAndTintGetter blockView, BlockPos pos, BlockState state) {
        this.wasUsed = true;
        this.extendedBlockStateModelCommands.add(new ExtendedBlockStateModelCommand(matrices.last().copy(), renderLayerFunction, model, r, g, b, light, overlay, outlineColor, blockView, pos, state));
    }

    @Override
    public List<ExtendedBlockCommand> fabric_getExtendedBlockCommands() {
        return this.extendedBlockCommands;
    }

    @Override
    public List<ExtendedBlockStateModelCommand> fabric_getExtendedBlockStateModelCommands() {
        return this.extendedBlockStateModelCommands;
    }

    @Inject(method={"clear"}, at={@At(value="RETURN")})
    private void onReturnClear(CallbackInfo ci) {
        this.extendedBlockCommands.clear();
        this.extendedBlockStateModelCommands.clear();
    }
}

