/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.renderer.client.block.model;

import java.util.function.Predicate;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.MeshBakedGeometry;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.Direction;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={SimpleModelWrapper.class})
abstract class SimpleModelWrapperMixin
implements BlockModelPart {
    @Shadow
    @Final
    private QuadCollection quads;
    @Shadow
    @Final
    private boolean useAmbientOcclusion;

    SimpleModelWrapperMixin() {
    }

    public void emitQuads(QuadEmitter emitter, Predicate<@Nullable Direction> cullTest) {
        QuadCollection quadCollection = this.quads;
        if (quadCollection instanceof MeshBakedGeometry) {
            MeshBakedGeometry meshBakedGeometry = (MeshBakedGeometry)quadCollection;
            if (this.useAmbientOcclusion) {
                meshBakedGeometry.getMesh().outputTo(emitter);
            } else {
                emitter.pushTransform(quad -> {
                    if (quad.ambientOcclusion() == TriState.DEFAULT) {
                        quad.ambientOcclusion(TriState.FALSE);
                    }
                    return true;
                });
                meshBakedGeometry.getMesh().outputTo(emitter);
                emitter.popTransform();
            }
        } else {
            super.emitQuads(emitter, cullTest);
        }
    }
}

